/*!
 * @package   yii2-grid
 * @author    Kartik Visweswaran <kartikv2@gmail.com>
 * @copyright Copyright &copy; Kartik Visweswaran, Krajee.com, 2014 - 2023
 * @version   3.5.3
 *
 * Grid Export Validation Module for Yii's Gridview. Supports export of
 * grid data as CSV, HTML, or Excel.
 *
 * Author: Kartik Visweswaran
 * Copyright: 2014 - 2023, Kartik Visweswaran, Krajee.com
 * For more JQuery plugins visit http://plugins.krajee.com
 * For more Yii related demos visit http://demos.krajee.com
 */
!function(t){"use strict";var e,o,i="urn:schemas-microsoft-com:office:";e={replaceAll:function(t,e,o){return t.split(e).join(o)},isEmpty:function(e,o){return null==e||0===e.length||o&&""===t.trim(e)},popupDialog:function(t,e,o,i){var n=screen.width/2-o/2;return window.open("",e,"",!0).close(),window.open(t,e,"toolbar=no, location=no, directories=no, status=yes, menubar=no, scrollbars=no, resizable=no, copyhistory=no, width="+o+", height="+i+", top=60, left="+n)},slug:function(t){return t.toLowerCase().replace(/[^\w ]+/g,"").replace(/ +/g,"-")},templates:{html:'<!DOCTYPE html><meta http-equiv="Content-Type" content="text/html;charset={encoding}"/><meta http-equiv="X-UA-Compatible" content="IE=edge;chrome=1"/>{css}<style>.kv-wrap{padding:20px}</style><body class="kv-wrap">{data}</body>',pdf:"{before}\n{data}\n{after}",excel:'<html xmlns:o="'+i+'office" xmlns:x="'+i+'excel" xmlns="http://www.w3.org/TR/REC-html40"><head><meta http-equiv="Content-Type" content="text/html;charset={encoding}"/>{css}\x3c!--[if gte mso 9]><xml><x:ExcelWorkbook><x:ExcelWorksheets><x:ExcelWorksheet><x:Name>{worksheet}</x:Name><x:WorksheetOptions><x:DisplayGridlines/></x:WorksheetOptions></x:ExcelWorksheet></x:ExcelWorksheets></x:ExcelWorkbook></xml><![endif]--\x3e</head><body>{data}</body></html>',popup:'<html style="display:table;width:100%;height:100%;"><title>Grid Export - &copy; Krajee</title><body style="display:table-cell;font-family:Helvetica,Arial,sans-serif;color:#888;font-weight:bold;line-height:1.4em;text-align:center;vertical-align:middle;width:100%;height:100%;padding:0 10px;">{msg}</body></html>'}},(o=function(e,o){var i=o.gridOpts,n=o.genOpts;this.$element=t(e),this.gridId=i.gridId,this.$grid=t("#"+this.gridId),this.dialogLib=o.dialogLib,this.messages=i.messages,this.target=i.target,this.exportConversions=i.exportConversions,this.skipExportElements=i.skipExportElements,this.showConfirmAlert=i.showConfirmAlert,this.action=i.action,this.bom=i.bom,this.encoding=i.encoding,this.module=i.module,this.filename=n.filename,this.expHash=n.expHash,this.showHeader=n.showHeader,this.showFooter=n.showFooter,this.showPageSummary=n.showPageSummary,this.$table=this.$grid.find(".kv-grid-table:first"),this.columns=this.showHeader?"td,th":"td",this.alertMsg=o.alertMsg,this.config=o.config,this.popup="",this.listen()}).prototype={constructor:o,getArray:function(o){var i=this,n=i.clean(o),s=[],r={};return void 0!==i.config.colHeads&&i.config.colHeads.length>0?s=i.config.colHeads:n.find("thead tr th").each(function(o){var n=t(this).text().trim(),r=e.slug(n);s[o]=!i.config.slugColHeads||e.isEmpty(r)?"col_"+o:r}),n.find('tbody tr:has("td")').each(function(e){r[e]={},t(this).children("td").each(function(o){var i=s[o];r[e][i]=t(this).text().trim()})}),r},setPopupAlert:function(t){if(void 0!==this.popup.document)if(arguments.length&&arguments[1]){var o=this.popup.document.getElementsByTagName("body");setTimeout(function(){o[0].innerHTML=t},1200)}else{var i=e.templates.popup.replace("{msg}",t);this.popup.document.write(i)}},processExport:function(t,o){var i=this;setTimeout(function(){e.isEmpty(o)?i[t]():i[t](o)},100)},listenClick:function(t){var o=this,i=arguments.length>1?arguments[1]:"",n=window[o.dialogLib];o.$element.off("click.gridexport").on("click.gridexport",function(s){if(s.stopPropagation(),s.preventDefault(),o.showConfirmAlert){var r=o.messages,a=e.isEmpty(o.alertMsg)?"":o.alertMsg,l=e.isEmpty(r.allowPopups)?"":r.allowPopups,h=e.isEmpty(r.confirmDownload)?"":r.confirmDownload,c="";if(c=a.length&&l.length?a+"\n\n"+l:!a.length&&l.length?l:a.length&&!l.length?a:"",h.length&&(c=c+"\n\n"+h),!e.isEmpty(c))return n.confirm(c,function(e){e&&o.processExport(t,i),s.preventDefault()}),!1}else o.processExport(t,i)})},listen:function(){this.$element.hasClass("export-csv")&&this.listenClick("exportTEXT","csv"),this.$element.hasClass("export-txt")&&this.listenClick("exportTEXT","txt"),this.$element.hasClass("export-html")&&this.listenClick("exportHTML"),this.$element.hasClass("export-xls")&&this.listenClick("exportEXCEL"),this.$element.hasClass("export-json")&&this.listenClick("exportJSON"),this.$element.hasClass("export-pdf")&&this.listenClick("exportPDF")},clean:function(e){var o,i=this,n=i.$table.clone(),s=i.$element.data("cssStyles")||{},r=i.$table.closest(".kv-grid-container"),a=i.skipExportElements,l=function(t){n.find(t+"."+i.gridId).remove()};a.length&&t.each(a,function(t,e){n.find(e).remove()}),"html"===e&&n.find(".kv-grid-boolean").remove(),(o=r.hasClass("kv-grid-wrapper")?r.closest(".floatThead-wrapper").find(".kv-thead-float thead"):r.find(".kv-thead-float thead")).length&&(o=o.clone(),n.find("thead").before(o).remove()),n.find("tr.filters").remove(),n.find("th").removeAttr("rowspan"),n.find("th").find("a").each(function(){t(this).contents().unwrap()}),n.find("form,input,textarea,select,script").remove(),n.find("[onclick]").removeAttr("onclick"),n.find('a[href*="javascript"]').attr("href","#"),i.showHeader||n.children("thead").remove(),i.showPageSummary||l(".kv-page-summary-container"),i.showFooter||l(".kv-footer-container"),i.showCaption||l(".kv-caption-container"),n.find(".skip-export").remove(),n.find(".skip-export-"+e).remove(),n.find(".strip-tags-export").each(function(){var e=t(this),o=e.text();e.html(o)});var h=n.html();return h=i.preProcess(h,e),n.html(h),t.each(s,function(e,o){n.find(e).each(function(){var e=t(this),i=e.attr("style")||"";t.each(o,function(t,e){i+=t+":"+e+";"}),i&&e.attr("style",i)})}),n},preProcess:function(t,o){var i,n,s,r=this.exportConversions,a=r.length,l=t,h="from_"+o,c="to_"+o;if(a>0)for(var p=0;p<a;p++)n=void 0!==(i=r[p])[h]?i[h]:void 0!==i.from?i.from:"",s=void 0!==i[c]?i[c]:void 0!==i.to?i.to:"",n.length&&s.length&&(l=e.replaceAll(l,n,s));return l},download:function(o,i){var n,s,r=this.$element,a=r.attr("data-mime")||"text/plain",l=window.yii,h=r.attr("data-hash")||"",c=r.attr("data-hash-export-config"),p=e.isEmpty(this.config)?{}:this.config,d=this.target,f=function(e,o){return t("<textarea/>",{name:e}).val(o).hide()};"json"===o&&p.jsonReplacer&&delete p.jsonReplacer,n=l?f(l.getCsrfParam()||"_csrf",l.getCsrfToken()||null):null,(s="_popup"===d)&&(d="kvDownloadDialog",this.popup=e.popupDialog("",d,350,120),this.popup.focus(),this.setPopupAlert(this.messages.downloadProgress)),t("<form/>",{action:this.action,class:"kv-export-form",target:d,method:"post",css:{display:"none"}}).append(f("export_filetype",o),f("export_filename",this.filename)).append(f("export_encoding",this.encoding),f("export_bom",this.bom?1:0)).append(f("export_content",i),f("module_id",this.module),n).append(f("export_mime",a),f("export_hash",h),f("hash_export_config",c)).append(f("export_config",JSON.stringify(p))).appendTo("body").submit().remove(),s&&this.setPopupAlert(this.messages.downloadComplete,!0)},exportHTML:function(){var o,i=this.clean("html"),n=this.config,s=n.cssFile?n.cssFile:[],r="";o=e.templates.html.replace("{encoding}",this.encoding),t.each(s,function(t,e){r+='<link href="'+e+'" rel="stylesheet" crossorigin="anonymous">\n'}),o=o.replace("{css}",r).replace("{data}",t("<div />").html(i).html()),this.download("html",o)},exportPDF:function(){var o=this.clean("pdf"),i=e.isEmpty(this.config.contentBefore)?"":this.config.contentBefore,n=e.isEmpty(this.config.contentAfter)?"":this.config.contentAfter,s=this.config.css,r=e.templates.pdf.replace("{css}",s).replace("{before}",i).replace("{after}",n).replace("{data}",t("<div />").html(o).html());this.download("pdf",r)},exportTEXT:function(e){var o=this,i=o.clean(e).find("tr:has("+o.columns+")"),n=String.fromCharCode(11),s=String.fromCharCode(0),r='"'+o.config.colDelimiter+'"',a='"'+o.config.rowDelimiter+'"',l='"'+i.map(function(e,i){return t(i).find(o.columns).map(function(e,o){return t(o).text().trim().replace(/"/g,'""')}).get().join(n)}).get().join(s).split(s).join(a).split(n).join(r)+'"';o.download(e,l)},exportJSON:function(){var t=this.getArray("json");t=JSON.stringify(t,this.config.jsonReplacer,this.config.indentSpace),this.download("json",t)},exportEXCEL:function(){var o,i,n=this.clean("xls"),s=this.config.cssFile&&this.config.cssFile.length?'<link href="'+this.config.cssFile+'" rel="stylesheet">':"";n.find("td[data-raw-value]").each(function(){((i=t(this)).css("mso-number-format")||0===i.css("mso-number-format")||"0"===i.css("mso-number-format"))&&i.html(i.attr("data-raw-value")).removeAttr("data-raw-value")}),o=e.templates.excel.replace("{encoding}",this.encoding).replace("{css}",s).replace("{worksheet}",this.config.worksheet).replace("{data}",t("<div />").html(n).html()).replace(/"/g,"'"),this.download("xls",o)}},t.fn.gridexport=function(e){var i=Array.apply(null,arguments);return i.shift(),this.each(function(){var n=t(this),s=n.data("gridexport"),r="object"==typeof e&&e;s||n.data("gridexport",s=new o(this,t.extend({},t.fn.gridexport.defaults,r,t(this).data()))),"string"==typeof e&&s[e].apply(s,i)})},t.fn.gridexport.defaults={dialogLib:"krajeeDialog"},t.fn.gridexport.Constructor=o}(window.jQuery);