<?php

/* @var $this yii\web\View */

$this->title = 'Bhagyarekha';
?>
<section class="home-banner">
    <div class="container">
        <div class="subtext">Bhagyarekha Civil Service Junior Presents</div>
        <h1>Bhagyarkha Mega Quiz <br> 2025</h1>
        <a href="quiz-registration" class="btn banner-btn">Register Quiz</a>
    </div>
</section>

<section id="about" class="about-us">
    <div class="container">
        <div class="col-md-6">
            <img src="<?= Yii::$app->request->baseUrl ?>/img/about.jpg" alt="bhagyarekha about">
        </div>
        <div class="col-md-6">
            <h2>About us</h2>
            <p>We, Bhagyarekha Edu-Tech, are a new-age edu-tech startup based in Thrissur, Kerala. We specialize in developing mobile applications that deliver high-quality teaching across a range of subjects for students from kindergarten through professional courses. Additionally, we offer top-notch coaching for various All India Level Exams such as UPSC, SSC, Railway Recruitment Board exams, CGL, MTS, NEET, JEE, CAT, and more. Our professional team is dedicated to blending cutting-edge technology with expert teaching to ensure the best results for our students.</p>
            <div class= "vision">
                <h2>Vision</h2>
                <p>Bhagyarekha Edu-Tech is more than just an online coaching platform; we act as mentors to our students, providing support and guiding them to achieve their dreams through high-quality teaching. Our vision is to reach every student, understand their strengths and weaknesses, and help them become what they aspire to be. By nurturing an ambitious and hardworking generation, we aim to contribute to improving the quality of life for people across our nation.</p>
            </div>
        </div>
    </div>
</section>

<section class ="season-name">
    <div class="container">
        <div class="col-md-6">
            <h3>Season 1</h3>
            <h2>The Real Battle of Knowledge</h2>
        </div>        
    </div>
</section>

<section class="container">
    <div class="topics">
        <h2>Topics</h2>
        <ul class="topic-list row">
            <li class="col-md-3 col-sm-6">
                <div class="inner">
                    <span class="number">01</span>
                    <span class="subject">India <br>Facts</span>
                </div>
                
            </li>
            <li class="col-md-3 col-sm-6">
                <div class="inner">
                    <span class="number">02</span>
                    <span class="subject">India <br>Geography</span>
                </div>
            </li>
            <li class="col-md-3 col-sm-6">
                <div class="inner">
                    <span class="number">03</span>
                    <span class="subject">States and Union<br>Territories</span>
                </div>
            </li>
            <li class="col-md-3 col-sm-6">
                <div class="inner">
                    <span class="number">04</span>
                    <span class="subject">India Current<br> Afffairs</span>
                </div>
            </li>
        </ul>
    </div>
</section>

<section class="container">
    <div class="program-structure">
        <h2>Program Structure</h2>
        <ul class="levels">
            <li class="main">
                <h3>Level 1: District Level</h3>
                <ul>
                    <li>Objective type exam at the district level.</li>
                    <li>1st and 2nd rank holders from each district advance to the Zonal Level Semi-Final.</li>
                </ul>
            </li>
            <li class="main">
                <h3>Level 2: Zonal Level - Semi-Final</h3>
                <ul>
                    <li>Multi-round quiz competition at North and South Zones.</li>
                    <li>1st four candidates from each zone proceed to the Mega Finale.</li>
                    <ul>
                        <li>North Zone: Thrissur, Palakkad, Malappuram, Kozhikode, Kannur, Wayanad, Kasaragod</li>
                        <li>South Zone: Ernakulam, Alappuzha, Kottayam, Idukki, Pathanamthitta, Kollam, Thiruvananthapuram</li>
                    </ul>
                </ul>
            </li>
            <li class="main">
                <h3>Level 3: Mega Finale</h3>
                <ul>
                    <li>The top 8 candidates from both zones face off in the Grand Quiz Finale!</li>
                </ul>
                <ul class="common-point">
                    <li>The Semi-Final and Mega Finale will be recorded and uploaded to our YouTube channel.</li>
                </ul>
            </li>
        </ul>
    </div>
</section>
    
<section class="container">
    <div class="participates">
        <h2>Who Can Participate?</h2>
        <ul class="participate-list row">
            <li class="col-md-4 col-sm-6">
                <div class="inner">
                    <span class="number">Category 01</span>
                    <span class="subject">Students of <br><span>Std. 5th to 7th</span></span>
                </div>
                
            </li>
            <li class="col-md-4 col-sm-6">
                <div class="inner">
                    <span class="number">Category 02</span>
                    <span class="subject">Students of <br><span>Std. 8th to 10th</span></span>
                </div>
            </li>
            <li class="col-md-4 col-sm-6">
                <div class="inner">
                    <span class="number">Category 03</span>
                    <span class="subject">Students of<br><span>+1, +2 and above</span></span>
                </div>
            </li>
        </ul>
    </div>
</section>

<section class="container">
    <div class="prizes">
        <h2>Prizes</h2>
        <ul class="prize-list row">
            <li class="col-md-4 col-sm-6">
                <div class="inner">
                    <figure>
                        <img src="<?= Yii::$app->request->baseUrl ?>/img/medal.png" alt="medal">
                        <figcaption>1st Prize</figcaption>
                    </figure>
                    <ul class="prize-details">
                        <li>1. ₹50,000 Cash Award</li>
                        <li>2. Trophy</li>
                        <li>3. Certificate</li>
                        <li>4. ₹4,000 Worth of Books</li>
                    </ul>
                </div>
            </li>
            <li class="col-md-4 col-sm-6">
                <div class="inner">
                    <figure>
                        <img src="<?= Yii::$app->request->baseUrl ?>/img/medal.png" alt="medal">
                        <figcaption>2nd Prize</figcaption>
                    </figure>
                    <ul class="prize-details">
                        <li>1. ₹30,000 Cash Award</li>
                        <li>2. Trophy</li>
                        <li>3. Certificate</li>
                        <li>4. ₹4,000 Worth of Books</li>
                    </ul>
                </div>
            </li>
            <li class="col-md-4 col-sm-6">
                <div class="inner">
                    <figure>
                        <img src="<?= Yii::$app->request->baseUrl ?>/img/medal.png" alt="medal">
                        <figcaption>3rd Prize</figcaption>
                    </figure>
                    <ul class="prize-details">
                        <li>1. ₹20,000 Cash Award</li>
                        <li>2. Trophy</li>
                        <li>3. Certificate</li>
                        <li>4. ₹4,000 Worth of Books</li>
                    </ul>
                </div>
            </li>
            <li class="col-md-6 col-sm-6">
                <div class="inner">
                    <figure>
                        <img src="<?= Yii::$app->request->baseUrl ?>/img/medal.png" alt="medal">
                        <figcaption>4th to 8th Consolation Prizes</figcaption>
                    </figure>
                    <ul class="prize-details">
                        <li>1. ₹10,000 Cash Award</li>
                        <li>2. Trophy</li>
                        <li>3. Certificate</li>
                        <li>4. ₹4,000 Worth of Books</li>
                    </ul>
                </div>
            </li>
            <li class="col-md-6 col-sm-6">
                <div class="inner">
                    <figure>
                        <img src="<?= Yii::$app->request->baseUrl ?>/img/medal.png" alt="medal">
                        <figcaption>Consolation Prize to Semi Finalists</figcaption>
                    </figure>
                    <ul class="prize-details">
                        <li>1. ₹5,000 Cash Award</li>
                        <li>2. Trophy</li>
                        <li>3. Certificate</li>
                        <li>4. ₹4,000 Worth of Books</li>
                    </ul>
                </div>
            </li>
        </ul>
    </div>
</section>

<section class="reg-details">
    <div class="container">
        <div class="col-md-6 details">
            <h2>Registration Details</h2>
            <ul>
                <li>For registering visit www.bhagyarekhaedu.com</li>
                <li>Registration fee: ₹300</li>
                <li>The candidates will be given a study material
      worth ₹260 & current affairs feeds every week
      as complimentary</li>
                <li>Prepare confidently for the quiz!</li>
            </ul>
            <div class="divider"></div>
            <div>
                <a href="quiz-registration" class="btn">Register Quiz</a>
            </div>
        </div>
    </div>
</section>
