<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use kartik\date\DatePicker;
use kartik\select2\Select2;
/* @var $this yii\web\View */
/* @var $model common\models\QuizRegistration */
/* @var $form yii\widgets\ActiveForm */
$districts = [
    'Alappuzha' => 'Alappuzha',
    'Ernakulam' => 'Ernakulam',
    'Idukki' => 'Idukki',
    'Kannur' => 'Kannur',
    'Kasaragod' => 'Kasaragod',
    'Kollam' => 'Kollam',
    'Kottayam' => 'Kottayam',
    'Kozhikode' => 'Kozhikode',
    'Malappuram' => 'Malappuram',
    'Palakkad' => 'Palakkad',
    'Pathanamthitta' => 'Pathanamthitta',
    'Thiruvananthapuram' => 'Thiruvananthapuram',
    'Thrissur' => 'Thrissur',
    'Wayanad' => 'Wayanad'
];
$backyear = date('Y-m-d', strtotime('-5 year'));
?>
<style>
    .form-group label{display:block; width: 100%;}
</style>
<div class="quiz-registration-form">
    <div class ="container">
        <?php $form = ActiveForm::begin(); ?>
        <div class="card card-success">
            <div class="card-header">
                <h3 class="card-title"> </h3>
            </div>
            <div class="card-body">
                <div class="col-md-6 col-md-offset-3">
                    <div class="row">
                        <div class="col-md-6">
                            <?= $form->field($model, 'name')->textInput(['maxlength' => true]) ?>
                        </div>
                        <div class="col-md-6">
                            <?= $form->field($model, 'parrant_guardian')->textInput(['maxlength' => true])->label("Parrant / Guardian Name") ?>
                        </div>
                    </div>    
                    <div class="row">
                        <div class="col-md-6">
                            <?= $form->field($model, 'dob')->textInput()->widget(DatePicker::classname(), ['options' => ['placeholder' => 'YYYY-MM-DD', 'autocomplete' => 'off'], 'pluginOptions' => ['format' => 'yyyy-mm-dd', 'todayHighlight' => true, 'autoclose' => true, 'endDate' => $backyear]])->label("Date of birth") ?>
                        </div>
                        <div class="col-md-6">
                            <?= $form->field($model, 'email')->textInput(['maxlength' => true]) ?>
                        </div>
                    </div>    
                    <div class="row">    
                        <div class="col-md-6">
                            <?= $form->field($model, 'gender')->dropDownList([ 'Male' => 'Male', 'Female' => 'Female', ], ['prompt' => 'Select Gender']) ?>
                        </div>
                        <div class="col-md-6">
                            <?= $form->field($model, 'district')->dropDownList($districts, ['prompt' => 'Select District']) ?>
                        </div>
                    </div>    
                    <div class="row">    
                        <div class="col-md-6">
                            <?= $form->field($model, 'contact_no')->textInput(['maxlength' => 10]) ?>
                        </div>
                        <div class="col-md-6">
                            <?= $form->field($model, 'whatsapp_no')->textInput(['maxlength' => 10]) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?= $form->field($model, 'address')->textarea(['rows' => 4]) ?>
                        </div>
                    </div>    
                    <div class="row">
                        <div class="col-md-6">
                            <?= $form->field($model, 'pin_code')->textInput(['maxlength' => 6]) ?>
                        </div>
                        <div class="col-md-6">
                            <?= $form->field($model, 'institution_type')->dropDownList([ 'School' => 'School', 'College' => 'College', 'Coaching Center' => 'Coaching Center', ], ['prompt' => 'Select Institutional Type']) ?>
                        </div>
                    </div>    
                    <div class="row">
                        <div class="col-md-6">
                            <?= $form->field($model, 'class')->dropDownList([ 5 => '5', 6 => '6', 7 => '7', 8 => '8', 9 => '9', 10 => '10', 11 => '11', 12 => '12', 'Diploma'=>'Diploma', 'Degree'=>'Degree','Master Degree'=>'Master Degree','Others'=>'Others' ], ['prompt' => 'Select Class / Course'])?>
                        </div>
                        <div class="col-md-6">
                            <?= $form->field($model, 'institution_name')->textInput(['maxlength' => true]) ?>
                        </div>
                    </div> 
                    <div class="form-group col-md-12 row">
                        <?= Html::submitButton('Register', ['class' => 'btn']) ?>
                    </div>
                </div>
                
            </div>
        </div>
        <?php ActiveForm::end(); ?>    
    </div>
</div>    
