<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\widgets\ActiveForm;
use yii\helpers\Url;
$this->registerCssFile('@web/css/jquery.alerts.css', ['depends' => [\yii\web\YiiAsset::class]]);
$this->registerJsFile('@web/js/bootstrap.min.js', ['depends' => [\yii\web\JqueryAsset::class]]);
$this->registerJsFile('@web/js/jquery.alerts.js', ['depends' => [\yii\web\JqueryAsset::class]]);
$this->registerJsFile('@web/js/jquery.countdownTimer.min.js', ['depends' => [\yii\web\JqueryAsset::class]]);

/* @var $this yii\web\View */
/* @var $searchModel common\models\MockTestSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */
$this->title = 'Mock Test';
$this->params['breadcrumbs'][] = $this->title;
?>
<style>
    .item {
        display: none;
        list-style:none;
        /*        float: left;*/
    }
    .item.active {
        display: block;
    }
    /* .mocktest{
        max-width: 600px;
        margin: 0 auto;
    } */
    .mocktest .logo{max-width: 200px;}
    .radio-text{padding-top: 8px; display: block;}
</style>
<div class="mocktest container">

    <div class="test-header clearfix">
        <div class="col-md-3 col-xs-6">
            <div class="logo">
                <a href="<?= Yii::$app->request->baseUrl ?>"><img src="<?= Yii::$app->request->baseUrl ?>/img/logo-sticky.png" alt="Bhagyarekha Edu Tech"></a>
            </div>
        </div>
        <div class="col-md-3 col-xs-6">
            <div class="right-blk">
                <span class="lblHeader" id="lblTimer">Time Remaining</span>
                <div id="timer" class="hasCountdown"><span id="ms_timer"></span> Minutes</div>
                <span class="btn-close">X</span>
            </div>
        </div>     
    </div>



    <div class="mocktest-inner pad-100-0">
        <?php
            $qno = 20;
            $minute = 1;
    //stop($action);

            $form = ActiveForm::begin([
                'id' => 'test_form',
                'action' => Url::to(['/mock-test/result']), // The action for the form
            ]);
    //stop($action);
        ?>

        <div class="row">
            <ul class="col-md-12">
                <?php

                shuffle($mockTests);  // Shuffle the array
                $randomQuestions = array_slice($mockTests, 0, $qno);
                $i = 0;
                foreach ($randomQuestions as $key => $values) {
                    ?>

                    <li class="item <?php echo($i == 0) ? 'active' : ''; ?>">
                        <div class="question-head">
                            <h3>Question <?php echo $i + 1;?></h3>
                            <?php if (!empty($values->question)) { ?>
                                <P><?php echo $values->question; ?> </P>
                            <?php } ?>
                        </div>
                        <?php if (!empty($values->image)) { ?>
                            <div class="question-img">
                                <img src="<?= Yii::$app->request->baseUrl  . "/uploads/freeTest/" . $values->image; ?>" class="thumb-image"/>
                            </div>
                        <?php } ?>
                        <input type="hidden" name="qstn_id[]" value="<?php echo $values->id; ?>">
                        <ul class="question-clues abstract clearfix">

                            <?php if (!empty($values->option_one)) { ?>
                                <li class="col-md-4 col-sm-6 col-xs-12">  
                                    <label class="radio">
                                        <input type="radio" name="answer<?php echo $values->id; ?>" value="<?php echo $values->option_one; ?>">
                                        <span class="outer">
                                            <span class="inner"></span>
                                        </span>
                                        <span class="radio-text"><?php echo $values->option_one; ?></span>
                                    </label>    
                                </li>
                            <?php } if (!empty($values->option_two)) { ?>    
                                <li class="col-md-4 col-sm-6 col-xs-12">
                                    <label class="radio">
                                        <input type="radio" name="answer<?php echo $values->id; ?>" value="<?php echo $values->option_two; ?>">
                                        <span class="outer">
                                            <span class="inner"></span>
                                        </span>
                                        <span class="radio-text"> <?php echo $values->option_two; ?></span>
                                    </label>     


                                </li>

                            <?php } if (!empty($values->option_three)) { ?>    
                                <li class="col-md-4 col-sm-6 col-xs-12">
                                    <label class="radio">
                                        <input type="radio" name="answer<?php echo $values->id; ?>" value="<?php echo $values->option_three; ?>">
                                        <span class="outer">
                                            <span class="inner"></span>
                                        </span>
                                        <span class="radio-text"><?php echo $values->option_three; ?></span>
                                    </label>  

                                </li>

                            <?php } if (!empty($values->option_four)) { ?>    
                                <li class="col-md-4 col-sm-6 col-xs-12">
                                    <label class="radio">
                                        <input type="radio" name="answer<?php echo $values->id; ?>" value="<?php echo $values->option_four; ?>">
                                        <span class="outer">
                                            <span class="inner"></span>
                                        </span>
                                        <span class="radio-text"><?php echo $values->option_four; ?></span>
                                    </label> 

                                </li>

                            <?php } if (!empty($values->option_five)) { ?>    
                                <li class="col-md-4 col-sm-6 col-xs-12">
                                    <label class="radio">
                                        <input type="radio" name="answer<?php echo $values->id; ?>" value="<?php echo $values->option_five; ?>">
                                        <span class="outer">
                                            <span class="inner"></span>
                                        </span>
                                        <span class="radio-text"><?php echo $values->option_five; ?></span>
                                    </label> 

                                </li>
                            <?php } ?>
                        </ul>


                    </li>
                    <?php
                    $i++;
                }
                ?>
                <li class="item text-center">
                    <h3 class="congrats">Congratulations!</h3>
                    <h3 class="pad-20">You have completed the Mock Test</h3>
                    <p class="pad-20">There is still some time left... you can go back, review your answers and change them if needed. <br>Or <br>you can continue and click Get Results</p>
                </li>
            </ul>
        </div>    
        <div class="test-footer">
            <div class="nav_buttons clearfix">
                <div class="prev">Prev</div>
                <button type="submit" class="submit nav" value="submit">Get Result</button>
                <div class="next">Next</div>
            </div>
            <div class="inner"> &copy; <?= date("Y"); ?> Bhagyarekha Edu Tech All rights reserved</div>
        </div>
        <?php ActiveForm::end(); ?>
        <div class="modal fade" id="myModal" tabindex="-1" role="dialog">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">Time Completed</h4>
                    </div>
                    <div class="modal-body">
                        <p>Time Completed !! Please Restart Your Test</p>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default blue-btn pull-left no-brd" data-dismiss="modal">Restart Test</button>
                        <a class="btn btn-primary blue-btn pull-right" href="#" onclick="closeWindow();" >Close</a>
                    </div>
                </div><!-- /.modal-content -->
            </div><!-- /.modal-dialog -->
        </div><!-- /.modal -->

    </div>      

</div> 
<?php
$this->registerJs("
    $('#ms_timer').countdowntimer({
        minutes: " . (int)$minute . ",  // Safely embed the PHP variable
        seconds: 0,
        size: 'lg',  // Use single quotes for the size property
        borderColor: '#FFF',
        backgroundColor: '#FFF',
        fontColor: '#339933',  // Corrected double # to a single #
        timeUp: timeisUp  // Ensure timeisUp is defined elsewhere in your JS
    });

    function timeisUp() {
        $('.nav_buttons').hide();
        $('#myModal').modal({
            show: true,
            keyboard: false,
            backdrop: 'static'
        }).on('hidden.bs.modal', function () {
            location.reload();
        });
        //Code to be executed when timer expires.
    }

    $('.prev').hide();
     $('.submit').hide();
    $('.prev, .next').on('click', function () {
         $('.submit').hide();
        var index = $('.active')[$(this).attr('class')]().index();
        if (index == 0) {
            $('.next').show();
            $('.prev').hide();
        } else
        {
            $('.next').show();
            $('.prev').show();
        }
        if ($('.item').length-1 == index) {
            $('.next').hide();
            $('.submit').show();
        }
        if (index != -1)
        {
            $('.active').removeClass('active')[$(this).attr('class')]().addClass('active');
        }
    });
    function closeWindow() {
        // window.opener.location.href = '/mock-test/start';
        self.close();
    }
    $(document).on('click', '.btn-close', function () {
        jConfirm('Are you sure to leave this page ?', 'Leave Page', function (r) {
            if (r) {
			self.close();
		}
		return false;
	   });
    });    
", \yii\web\View::POS_READY);
?>
