<?php

namespace frontend\controllers;

use Yii;
use common\models\QuizRegistration;
use common\models\QuizRegistrationSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use common\components\Helper;
use common\models\User;

/**
 * QuizRegistrationController implements the CRUD actions for QuizRegistration model.
 */
class QuizRegistrationController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all QuizRegistration models.
     * @return mixed
     */
    public function actionIndex()
    {
        $model = new QuizRegistration();

        if ($model->load(Yii::$app->request->post())) {
            $model->reg_number = Helper::RandUsername($model->name, $model->dob,$model->gender,$model->district,$model->institution_type);
            date_default_timezone_set("Asia/Kolkata");
            $model->created_on = date("Y-m-d");
            $model->created_at = date("Y-m-d H:i:s");
            if ($model->validate() && $model->save()){
                return $this->redirect(['payment', 'id' => $model->reg_number]);
            }

            
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Displays a single QuizRegistration model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        $otp = Yii::$app->request->get('action');
        $model = User::find()->where(['otp' => $otp])->one();
        if ($model) {
            return $this->render('view', [
                'model' => $model,
            ]);
        } else{
            return $this->redirect(['/index']);
        }
    }

    /**
     * Creates a new QuizRegistration model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new QuizRegistration();

        if ($model->load(Yii::$app->request->post())) {
            $model->reg_number = Helper::RandStr(10);
            if ($model->validate() && $model->save()){
                return $this->redirect(['payment', 'id' => $model->reg_number]);
            }

            
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    public function actionPayment()
    {
        $otp = Yii::$app->request->get('id');
        $model = QuizRegistration::find()->where(['reg_number' => $otp])->one();
        if ($model) {
            return $this->render('payment', [
                'model' => $model,
            ]);
        } else{
            return $this->redirect(['/index']);
        }
    }

    /**
     * Updates an existing QuizRegistration model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing QuizRegistration model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the QuizRegistration model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return QuizRegistration the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = QuizRegistration::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
