<?php

namespace frontend\controllers;

use Yii;
use common\models\MockTest;
use common\models\MockTestResult;
use common\models\MockTestSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

/**
 * MockTestController implements the CRUD actions for MockTest model.
 */
class MockTestController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    public function actionResult() {
        
        // stop($_POST);
        $this->layout = 'blank';
       if (isset($_POST['qstn_id'])) {
           $result = array();
           $userAnswer=array();
           foreach ($_POST['qstn_id'] as $key => $value) {
               $answer = MockTest::findOne($value);
               if (isset($_POST['answer' . $value])) {
                    if ($_POST['answer' . $value]=='') {
                        $result[$key] = 'skip';
                        $answers[$key] = $answer;
                        $userAnswer[$key]='';
                    } else if ($answer->answer == $_POST['answer' . $value]) {
                        
                        $result[$key] = 'true';
                        $answers[$key] = $answer;
                        $userAnswer[$key]=$_POST['answer' . $value];
                    } else
                            $result[$key] = 'false';
                            $answers[$key] = $answer;
                            $userAnswer[$key]=$_POST['answer' . $value];
                }
                else{
                    $result[$key] = 'skip';
                    $answers[$key] = $answer;
                    $userAnswer[$key]='';
                }
           }
       }
       else{
            return $this->redirect(['../']);
       }
       return $this->render('result', [
            'result' => $result,
            'answers' => $answers,
            'userAnswer' => $userAnswer,
        ]);
    }

    /**
     * Lists all MockTest models.
     * @return mixed
     */
    public function actionIndex()
    {
        $model = new MockTestResult();
        date_default_timezone_set('Asia/Kolkata');
        $model->date = date('Y-m-d H:i:s');
        
        if ($model->load(Yii::$app->request->post())) {

            $model->save();
            Yii::$app->session->setFlash('mocktest', true);
            $result =$model;
            return $this->redirect(['start', 'result' => $result]);
        }

        return $this->render('create', [
            'model' => $model,
        ]);
        // $searchModel = new MockTestSearch();
        // $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        // return $this->render('index', [
        //     'searchModel' => $searchModel,
        //     'dataProvider' => $dataProvider,
        // ]);
    }

    /**
     * Displays a single MockTest model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionStart()
    {
        date_default_timezone_set('Asia/Kolkata');

        // Define quiz open and close times
        $quizOpenTime = strtotime(date('Y-m-d') . ' 20:02:00'); // 8:00 PM IST
        $quizCloseTime = strtotime(date('Y-m-d') . ' 20:03:00'); // 8:10 PM IST
        $currentTime = time();

        $this->layout = 'blank';
        $mockTests = MockTest::findAll(['status' => 1]);
        return $this->render('mocktest', [
            'mockTests' => $mockTests,
            'quizOpenTime' => $quizOpenTime,
            'quizCloseTime' => $quizCloseTime,
            'currentTime' => $currentTime,
        ]);
    }

    /**
     * Creates a new MockTest model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new MockTest();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing MockTest model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing MockTest model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the MockTest model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return MockTest the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = MockTest::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
