<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "quiz_registration".
 *
 * @property int $id
 * @property string $reg_number
 * @property string $name
 * @property string $dob
 * @property string $gender
 * @property string $email
 * @property string $district
 * @property string $parrant_guardian
 * @property string $contact_no
 * @property string $whatsapp_no
 * @property string $address
 * @property int $pin_code
 * @property string $institution_type
 * @property string $institution_name
 * @property string $class
 */
class QuizRegistration extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'quiz_registration';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['reg_number', 'name', 'dob', 'gender', 'email', 'district', 'parrant_guardian', 'contact_no', 'whatsapp_no', 'address', 'pin_code', 'institution_type', 'institution_name', 'class'], 'required'],
            [['gender', 'address', 'institution_type'], 'string'],
            [['pin_code','contact_no', 'whatsapp_no'], 'integer'],
            [['reg_number', 'dob', 'class'], 'string', 'max' => 20],
            [['name', 'email'], 'string', 'max' => 100],
            [['email'], 'unique'],
            [['district', 'parrant_guardian'], 'string', 'max' => 50],
            [['contact_no', 'whatsapp_no'], 'string','min' => 10, 'max' => 10],
            [['pin_code'], 'string','min' => 6, 'max' => 6],
            [['institution_name'], 'string', 'max' => 200],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'reg_number' => 'Reg Number',
            'name' => 'Name',
            'dob' => 'Dob',
            'gender' => 'Gender',
            'email' => 'Email',
            'district' => 'District',
            'parrant_guardian' => 'Parrant Guardian',
            'contact_no' => 'Contact No',
            'whatsapp_no' => 'Whatsapp No',
            'address' => 'Address',
            'pin_code' => 'Pin Code',
            'institution_type' => 'Institution Type',
            'institution_name' => 'Institution Name',
            'class' => 'Class',
        ];
    }
}
