<?php

namespace common\models;

use Yii;
use yii\db\Expression;
/**
 * This is the model class for table "mock_test".
 *
 * @property int $id
 * @property string $question
 * @property string $image
 * @property string $answer
 * @property string $solution
 * @property string $option_one
 * @property string $option_two
 * @property string $option_three
 * @property string $option_four
 * @property string $option_five
 * @property string $add_date
 * @property string $edit_date
 * @property int $status
 */
class MockTest extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'mock_test';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['question', 'answer', 'option_one', 'option_two'], 'required'],
            [['question', 'image', 'solution'], 'string'],
            [['add_date', 'edit_date'], 'safe'],
            [['status'], 'integer'],
            [['answer', 'option_one', 'option_two', 'option_three', 'option_four', 'option_five'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'question' => 'Question',
            'image' => 'Image',
            'answer' => 'Answer',
            'solution' => 'Solution',
            'option_one' => 'Option One',
            'option_two' => 'Option Two',
            'option_three' => 'Option Three',
            'option_four' => 'Option Four',
            'option_five' => 'Option Five',
            'add_date' => 'Add Date',
            'edit_date' => 'Edit Date',
            'status' => 'Status',
        ];
    }
    // public function beforeSave() {
    //     if ($this->isNewRecord) {
    //         $this->add_date = new Expression('NOW()');
    //         $this->edit_date = new Expression('NOW()');
    //     } else {
    //         $this->edit_date = new Expression('NOW()');
    //     }
    //     return parent::beforeSave();
    // }
}
