<?php

use yii\helpers\Html;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $searchModel common\models\QuizRegistrationSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Quiz Registrations';
$this->params['breadcrumbs'][] = $this->title;
$districts = [
    'Alappuzha' => 'Alappuzha',
    'Ernakulam' => 'Ernakulam',
    'Idukki' => 'Idukki',
    'Kannur' => 'Kannur',
    'Kasaragod' => 'Kasaragod',
    'Kollam' => 'Kollam',
    'Kottayam' => 'Kottayam',
    'Kozhikode' => 'Kozhikode',
    'Malappuram' => 'Malappuram',
    'Palakkad' => 'Palakkad',
    'Pathanamthitta' => 'Pathanamthitta',
    'Thiruvananthapuram' => 'Thiruvananthapuram',
    'Thrissur' => 'Thrissur',
    'Wayanad' => 'Wayanad'
];
?>
<div class="quiz-registration-index">
    <div class="box clearfix">
        <div class="box-body table-responsive">
            <?= GridView::widget([
                'dataProvider' => $dataProvider,
                'filterModel' => $searchModel,
                'columns' => [
                    ['class' => 'yii\grid\SerialColumn'],
                    // 'id',
                    'reg_number',
                    'name',
                    'parrant_guardian',
                    // 'dob',
                    [
                        'attribute' => 'gender',
                        'format' => 'raw',
                        'filter' => Html::activeDropDownList($searchModel, 'gender', ["Male" => "Male", "Female" => "Female"], ['class' => 'form-control', 'prompt' => 'Select All']),
                    ],
                    'email:email',
                    [
                        'attribute' => 'district',
                        'format' => 'raw',
                        'filter' => Html::activeDropDownList($searchModel, 'district', $districts, ['class' => 'form-control', 'prompt' => 'Select All']),
                    ],
                    
                    'contact_no',
                    'whatsapp_no',
                    //'address:ntext',
                    'pin_code',
                    [
                        'attribute' => 'institution_type',
                        'format' => 'raw',
                        'filter' => Html::activeDropDownList($searchModel, 'institution_type', ['School' => 'School', 'College' => 'College', 'Coaching Center' => 'Coaching Center'], ['class' => 'form-control', 'prompt' => 'Select All']),
                    ],
                    'institution_name',
                    [
                        'attribute' => 'class',
                        'format' => 'raw',
                        'filter' => Html::activeDropDownList($searchModel, 'class', [ 5 => '5', 6 => '6', 7 => '7', 8 => '8', 9 => '9', 10 => '10', 11 => '11', 12 => '12', 'Diploma'=>'Diploma', 'Degree'=>'Degree','Master Degree'=>'Master Degree' ], ['class' => 'form-control', 'prompt' => 'Select All']),
                    ],

                    // ['class' => 'yii\grid\ActionColumn'],
                ],
            ]); ?>
        </div>
    </div>
</div>
