<?php

/* @var $this \yii\web\View */
/* @var $content string */

use yii\helpers\Html;
use yii\bootstrap\Nav;
use yii\bootstrap\NavBar;
use yii\widgets\Breadcrumbs;
use frontend\assets\AppAsset;
use common\widgets\Alert;
use yii\helpers\Url;
// Get base URL
$base_url = "https://" . $_SERVER['HTTP_HOST'];

// Remove trailing slash if present
$base_url = rtrim($base_url, '/');

AppAsset::register($this);
?>
    <?php $this->beginPage() ?>
        <!DOCTYPE html>
        <html lang="<?= Yii::$app->language ?>">

        <head>
            <meta charset="<?= Yii::$app->charset ?>">
            <meta http-equiv="X-UA-Compatible" content="IE=edge">
            <meta name="viewport" content="width=device-width, initial-scale=1">
            <link rel="icon" type="image/x-icon" href="<?= $base_url ?>/img/favicon.ico">
            <?= Html::csrfMetaTags() ?>
                <title>
                    <?= Html::encode($this->title) ?>
                </title>
                <link rel="preconnect" href="https://fonts.googleapis.com">
                <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
                <link href="https://fonts.googleapis.com/css2?family=Onest:wght@100..900&display=swap" rel="stylesheet">
                <?php $this->head() ?>
        </head>

        <body>
            <?php $this->beginBody() ?>
                <header id="masthead" class="sticky-header site-header">
                    <div class="container">
                        <div class="row">
                            <div class="navigation col-sm-12">
                                <nav class="navbar navbar-custom" role="navigation">
                                    <div class="container">
                                        <div class="navbar-header">
                                            <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".navbar-main-collapse"> <i class="fa fa-bars"></i> </button> <a href="../" rel="home" class="sticky-logo"><img src="<?= $base_url ?>/img/logo-sticky.png" alt="Bhagyarekha"></a> </div>
                                        <!-- Collect the nav links, forms, and other content for toggling -->
                                        <div class="collapse navbar-collapse navbar-right navbar-main-collapse">
                                            <ul class="nav navbar-nav">
                                                <!-- Hidden li included to remove active class from about link when scrolled up past about section -->
                                                <li class="hidden">
                                                    <a href="#page-top"></a>
                                                </li>
                                                <?php 
                        if (Yii::$app->controller->action->id === 'index') {
                    ?>
                                                    <!-- <li> <a class="page-scroll" href="#about">About</a> </li>
                                                    <li> <a class="page-scroll" href="#team">Topics</a> </li>
                                                    <li> <a class="page-scroll" href="#testimonials">Prices</a> </li> -->
                                                    <li> <a class="page-scroll register btn" href="<?= Yii::$app->request->baseUrl ?>quiz-registration">Register Quiz</a> </li>
                                                    <?php
                    }
                    ?>
                                                        
                                            </ul>
                                        </div>
                                        <!-- /.navbar-collapse -->
                                    </div>
                                    <!-- /.container -->
                                </nav>
                            </div>
                        </div>
                    </div>
                </header>
                <?php
//    NavBar::begin([
//        'brandLabel' => Yii::$app->name,
//        'brandUrl' => Yii::$app->homeUrl,
//        'options' => [
//            'class' => 'navbar-inverse navbar-fixed-top',
//        ],
//    ]);
//    if (Yii::$app->user->isGuest) {
//        $menuItems[] = ['label' => 'Registration', 'url' => ['/site/signup']];
//        $menuItems[] = ['label' => 'Login', 'url' => ['/site/login']];
//    } else {
//        $menuItems[] = '<li>'
//            . Html::beginForm(['/site/logout'], 'post')
//            . Html::submitButton(
//                'Logout (' . Yii::$app->user->identity->username . ')',
//                ['class' => 'btn btn-link logout']
//            )
//            . Html::endForm()
//            . '</li>';
//    }
//    echo Nav::widget([
//        'options' => ['class' => 'navbar-nav navbar-right'],
//        'items' => $menuItems,
//    ]);
//    NavBar::end();
    ?>
                    <?= Breadcrumbs::widget([
            'links' => isset($this->params['breadcrumbs']) ? $this->params['breadcrumbs'] : [],
        ]) ?>
                        <?= $content ?>
                        
                        <footer>
                            <div class="container">&copy <?= date("Y"); ?> Bhagyarekha Edu Tech All rights reserved</div>
                        </footer>
                            

                            <?php $this->endBody() ?>
        </body>

        </html>
        <?php $this->endPage() ?>