<?php
namespace frontend\models;

use yii\base\Model;
use common\models\User;

/**
 * Signup form
 */
class SignupForm extends Model
{
    public $username;
    public $fullname;
    public $phone;
    public $type;
    public $gender;
    public $email;
    public $password;


    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
//            ['username', 'trim'],
//            ['username', 'required'],
//            ['username', 'unique', 'targetClass' => '\common\models\User', 'message' => 'This username has already been taken.'],
//            ['username', 'string', 'min' => 2, 'max' => 255],

            ['fullname', 'required'],
            ['phone', 'required'],
            ['type', 'required'],
            ['gender', 'required'],
            
            ['email', 'trim'],
            ['email', 'required'],
            ['email', 'email'],
            ['email', 'string', 'max' => 255],
            ['email', 'unique', 'targetClass' => '\common\models\User', 'message' => 'This email address has already been taken.'],

//            ['password', 'required'],
            ['password', 'string', 'min' => 6],
        ];
    }

    
 public function attributeLabels()
    {
        return [
            'type' => 'Who am I',
            
            ];
    }
    
    /**
     * Signs user up.
     *
     * @return User|null the saved model or null if saving fails
     */
    public function signup()
    {
        if (!$this->validate()) {
            return null;
        }
        
        $user = new User();
        $password="123456";
        $user->full_name = $this->fullname;
        $user->phone = $this->phone;
        $user->gender = $this->gender;
        $user->type = $this->type;
        $user->username = $this->email;
        $user->email = $this->email;
        $user->setPassword($password);
        $user->generateAuthKey();
        
        return $user->save() ? $user : null;
    }
}
