<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model common\models\QuizRegistration */

$this->title = $model->name;
$this->params['breadcrumbs'][] = ['label' => 'Quiz Registrations', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);

if ($model->pay_status ==0){
    $pay_status = 'Not Paid';
}
else{
    $pay_status = 'Paid';
}
?>
<div class="quiz-registration-view">
<style>
    .box-content{margin-bottom:15px}
</style>
    <!-- <h1><?= Html::encode($this->title) ?></h1> -->

    <p>
        <?= Html::a('Update', ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
        <?php if ($model->pay_status == 0){?>
        <?= Html::a('Add Payment', ['add-payment', 'id' => $model->id], [
            'class' => 'btn btn-success',
            'data' => [
                'confirm' => 'Are you sure add payment to this member?',
                'method' => 'post',
            ],
        ]) ?>
        <?php }?>
    </p>

    <div class="row">
        <div class="col-md-3 col-sm-6 col-xs-12">
            <div class="info-box">
                <span class="info-box-icon bg-aqua"><i class="fa fa-user-o"></i></span>
                <div class="info-box-content">
                <span class="info-box-text">Name</span>
                <span class="info-box-number"> <?= $model->name ?></span>
                </div>
            </div>
        </div>

        <div class="col-md-3 col-sm-6 col-xs-12">
            <div class="info-box">
                <span class="info-box-icon bg-green"><i class="fa fa-star-o"></i></span>
                <div class="info-box-content">
                <span class="info-box-text">Register Number</span>
                <span class="info-box-number"><a href="<?= Yii::$app->request->baseUrl ?>/../quiz-registration/payment?id=<?= $model->reg_number ?>" target="_blank"><?= $model->reg_number ?></a></span>
                </div>
            </div>
        </div>

        <div class="col-md-3 col-sm-6 col-xs-12">
            <div class="info-box">
                <span class="info-box-icon bg-green"><i class="fa fa-money"></i></span>
                <div class="info-box-content">
                <span class="info-box-text">Payment Status</span>
                <span class="info-box-number"><?= $pay_status ?></span>
                </div>
            </div>
        </div>
        <div class="col-md-3 col-sm-6 col-xs-12">
            <div class="info-box">
                <span class="info-box-icon bg-yellow"><i class="fa fa-envelope-o"></i></span>
                <div class="info-box-content">
                <span class="info-box-text">Email</span>
                <span class="info-box-number"><?= $model->email ?></span>
                </div>
            </div>
        </div>

    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="box">
                <div class="box-header">
                    <h3 class="box-title">Other Details</h3>
                </div>
                <div class="box-body">
                    <div class="box-content col-md-3">
                        <span class="info-box-text">Dob</span>
                        <span class="info-box-number"><?= $model->dob ?></span>
                    </div>
                
                    <div class="box-content col-md-3">
                        <span class="info-box-text">Gender</span>
                        <span class="info-box-number"><?= $model->gender ?></span>
                    </div>
                
                    <div class="box-content col-md-3">
                        <span class="info-box-text">District</span>
                        <span class="info-box-number"><?= $model->district ?></span>
                    </div>
                
                    <div class="box-content col-md-3">
                        <span class="info-box-text">Parrant / Guardian</span>
                        <span class="info-box-number"><?= $model->parrant_guardian ?></span>
                    </div>
                
                    <div class="box-content col-md-3">
                        <span class="info-box-text">Contact Number</span>
                        <span class="info-box-number"><?= $model->contact_no ?></span>
                    </div>
                
                    <div class="box-content col-md-3">
                        <span class="info-box-text">Whatsapp Number</span>
                        <span class="info-box-number"><a href="https://api.whatsapp.com/send?phone=91<?= $model->whatsapp_no ?>" target="_blank"><?= $model->whatsapp_no ?></a></span>
                    </div>
                
                    <div class="box-content col-md-3">
                        <span class="info-box-text">Address</span>
                        <span class="info-box-number"><?= $model->address ?></span>
                    </div>

                    <div class="box-content col-md-3">
                        <span class="info-box-text">Pin</span>
                        <span class="info-box-number"><?= $model->pin_code ?></span>
                    </div>

                    <div class="box-content col-md-3">
                        <span class="info-box-text">Institutuion Type</span>
                        <span class="info-box-number"><?= $model->institution_type ?></span>
                    </div>

                    <div class="box-content col-md-3">
                        <span class="info-box-text">Institutuion Name</span>
                        <span class="info-box-number"><?= $model->institution_name ?></span>
                    </div>

                    <div class="box-content col-md-3">
                        <span class="info-box-text">Class</span>
                        <span class="info-box-number"><?= $model->class ?></span>
                    </div>

            </div>  
        </div>
    </div>

