<?php

use yii\helpers\Html;
use yii\grid\GridView;
use common\models\User;
/* @var $this yii\web\View */
/* @var $searchModel common\models\QuizRegistrationSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */
$role= Yii::$app->user->identity->role;

$this->title = 'Quiz Registrations';
$this->params['breadcrumbs'][] = $this->title;
$districts = [
    'Alappuzha' => 'Alappuzha',
    'Ernakulam' => 'Ernakulam',
    'Idukki' => 'Idukki',
    'Kannur' => 'Kannur',
    'Kasaragod' => 'Kasaragod',
    'Kollam' => 'Kollam',
    'Kottayam' => 'Kottayam',
    'Kozhikode' => 'Kozhikode',
    'Malappuram' => 'Malappuram',
    'Palakkad' => 'Palakkad',
    'Pathanamthitta' => 'Pathanamthitta',
    'Thiruvananthapuram' => 'Thiruvananthapuram',
    'Thrissur' => 'Thrissur',
    'Wayanad' => 'Wayanad'
];
?>
<div class="quiz-registration-index">
    <div class="box clearfix">
        <div class="box-body table-responsive">
            <?= GridView::widget([
                'dataProvider' => $dataProvider,
                'filterModel' => $searchModel,
                // 'rowOptions' => function ($model) {
                //                 if ($model->pay_status == '1') {
                //                     return ['class' => 'bg-green'];
                //                 }
                //             },
                'columns' => [
                    ['class' => 'yii\grid\SerialColumn'],
                    // 'id',
                    'reg_number',
                    'name',
                    'parrant_guardian',
                    // 'dob',
                    [
                        'attribute' => 'gender',
                        'format' => 'raw',
                        'filter' => Html::activeDropDownList($searchModel, 'gender', ["Male" => "Male", "Female" => "Female"], ['class' => 'form-control', 'prompt' => 'Select All']),
                    ],
                    'email:email',
                    [
                        'attribute' => 'district',
                        'format' => 'raw',
                        'filter' => Html::activeDropDownList($searchModel, 'district', $districts, ['class' => 'form-control', 'prompt' => 'Select All']),
                    ],
                    
                    'contact_no',
                    'whatsapp_no',
                    //'address:ntext',
                    // 'pin_code',
                    [
                        'attribute' => 'institution_type',
                        'format' => 'raw',
                        'filter' => Html::activeDropDownList($searchModel, 'institution_type', ['School' => 'School', 'College' => 'College', 'Coaching Center' => 'Coaching Center'], ['class' => 'form-control', 'prompt' => 'Select All']),
                    ],
                    'institution_name',
                    [
                        'attribute' => 'class',
                        'format' => 'raw',
                        'filter' => Html::activeDropDownList($searchModel, 'class', [ 5 => '5', 6 => '6', 7 => '7', 8 => '8', 9 => '9', 10 => '10', 11 => '11', 12 => '12', 'Diploma'=>'Diploma', 'Degree'=>'Degree','Master Degree'=>'Master Degree' ], ['class' => 'form-control', 'prompt' => 'Select All']),
                    ],

                    ['class' => 'yii\grid\ActionColumn',
                        'headerOptions' => ['class' => 'action-column'],
                        'contentOptions' => ['style' => 'width:50px;'],
                        'header' => 'Actions',
                        // 'visible' => (($role == User::ROLE_SUPER_ADMIN) ||($role == User::ROLE_ADMIN) || ($role == User::ROLE_CO_ADMIN) || ($role == User::ROLE_STAFF)) ? true : false,
                        'template' => '{view}{update}{delete}',
                        'visibleButtons' => [
                            'view' => true,
                            'update' => true,
                            'delete' => true,
                        ],
                        'buttons' => [
                                        'view' => function ($url, $model)  use ($role){
                                            if(($role == User::ROLE_SUPER_ADMIN) ||($role == User::ROLE_ADMIN) || ($role == User::ROLE_CO_ADMIN))
                                            {
                                                return Html::a('<div class="btn btn-success btn-flat btn-xs"><span class="glyphicon glyphicon-eye-open"></span> View</div>', $url, [
                                                            'title' => Yii::t('app', 'customer-view'),
                                                ]);
                                            }
                                        },
                                        'update' => function ($url, $model) {
                                            return Html::a('<div class="btn btn-info btn-flat btn-xs"><span class="glyphicon glyphicon-pencil"></span> Edit</div>', $url, [
                                                        'title' => Yii::t('app', 'customer-update'),
                                            ]);
                                        },
                                        'delete' => function ($url, $model) {
                                            if($model->pay_status == 0)
                                            {
                                                return Html::a('<div class="btn btn-danger btn-flat btn-xs"><span class="glyphicon glyphicon-trash"></span> Remove</div>', $url, [
                                                            'title' => Yii::t('app', 'customer-delete'),
                                                ]);
                                            }
                                        }
                            ],
                    ],
                ],
            ]); ?>
        </div>
    </div>
</div>
