<?php

namespace backend\controllers;

use Yii;
use common\models\QuizRegistration;
use common\models\QuizRegistrationSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use common\components\Helper;
/**
 * QuizRegistrationController implements the CRUD actions for QuizRegistration model.
 */
class QuizRegistrationController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all QuizRegistration models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new QuizRegistrationSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single QuizRegistration model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new QuizRegistration model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new QuizRegistration();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing QuizRegistration model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post())) {
            $model->reg_number = Helper::RandUsername($model->name, $model->dob,$model->gender,$model->district,$model->institution_type);
            // date_default_timezone_set("Asia/Kolkata");
            // $model->created_on = date("Y-m-d");
            // $model->created_at = date("Y-m-d H:i:s");
            if ($model->validate() && $model->save()){
                return $this->redirect(['view', 'id' => $model->id]);
            }

            
        }

        // if ($model->load(Yii::$app->request->post()) && $model->save()) {
        //     return $this->redirect(['view', 'id' => $model->id]);
        // }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    public function actionSoftDelete($id)
    {
        $model = $this->findModel($id);
        $model->pin_code = (string)$model->pin_code;
        $model->status = 0 ;
        if (!$model->save()){
            stop($model->getErrors());
        }
       
        return $this->redirect(['index']);
    }

    public function actionAddPayment($id)
    {
        $model = $this->findModel($id);
        $model->pin_code = (string)$model->pin_code;
        $model->pay_status = 1 ;
        if (!$model->save()){
            stop($model->getErrors());
        }
        // else{
            // $subject = "Payment Confirmation";
            // $message = "Dear " . $model->name . ",\n\nThank you for your registration.\n\nYour Registration ID is " . $model->reg_number . ".\n\nWe have received your registration fee and sent your study materials to your registered address. If you do not receive them within 15 days, please contact us at 8594000241. We wish you the best and hope you win first prize!";
            // $resp = Helper::sendMail($model->email, $subject, $message);
        // }
        
        return $this->redirect(['index']);
    }

    /**
     * Deletes an existing QuizRegistration model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        // $this->findModel($id)->delete();
        $model = $this->findModel($id);
        $model->pin_code = (string)$model->pin_code;
        $model->status = 0 ;
        if (!$model->save()){
            stop($model->getErrors());
        }
        return $this->redirect(['index']);
    }

    /**
     * Finds the QuizRegistration model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return QuizRegistration the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = QuizRegistration::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
