<!-- start Simple Custom CSS and JS -->
<script type="text/javascript">
let currentIndex = 0;
const sections = document.querySelectorAll('.section');
const totalSections = sections.length;

let canScroll = true; // Prevents continuous scrolling

function fadeToSection(index) {
    // Ensure the index is within bounds
    if (index < 0) index = 0;
    if (index >= totalSections) index = totalSections - 1;

    // Remove the 'active' class from all sections
    sections.forEach(section => section.classList.remove('active'));

    // Add the 'active' class to the target section
    sections[index].classList.add('active');

    // Add a class to the body indicating the active section
    const bodyClassName = `section-${index + 1}`;
    if (!document.body.classList.contains(bodyClassName)) {
        // Remove the previous section class, if any
        const previousClass = Array.from(document.body.classList).find(className => className.startsWith('section-'));
        if (previousClass) {
            document.body.classList.remove(previousClass);
        }
        // Add the new class to the body
        document.body.classList.add(bodyClassName);
    }

    currentIndex = index;
}

window.addEventListener('wheel', (event) => {
    if (!canScroll) return; // If the previous transition hasn't finished, ignore new events

    canScroll = false; // Prevent additional scrolls during transition

    if (event.deltaY > 0) {
        // Scroll down
        currentIndex++;
    } else {
        // Scroll up
        currentIndex--;
    }

    // Make sure currentIndex is within valid range
    if (currentIndex < 0) currentIndex = 0;
    if (currentIndex >= totalSections) currentIndex = totalSections - 1;

    // Fade to the corresponding section
    fadeToSection(currentIndex);

    // Allow scrolling again after a short delay (adjust delay as needed)
    setTimeout(() => {
        canScroll = true;
    }, 2000); // Adjust time to match the section transition (e.g., 1s)
});

//window.addEventListener('load', () => {
 //   document.body.classList.add('section-1');
//    fadeToSection(currentIndex); // Ensure first section is active on load
//});

window.addEventListener('load', () => {
    setTimeout(() => {
        document.body.classList.add('section-1');
    }, 5000); // Adds the class after 500ms (half a second)
});
</script>
<!-- end Simple Custom CSS and JS -->
