<!-- start Simple Custom CSS and JS -->
<script type="text/javascript">
document.addEventListener("DOMContentLoaded", function () {
    // Simulate the page loading process and update the percentage
    let loadingPercentage = 0;
    let loadingInterval = setInterval(function () {
        loadingPercentage += 1; // Increment the loading percentage

        let loadingText = document.querySelector('.loading-text');
        if (loadingText) {
            loadingText.innerText = loadingPercentage + "%";
        }

        if (loadingPercentage === 100) {
            clearInterval(loadingInterval);

            let loaderContainer = document.querySelector('.loader-container');
            let content = document.querySelector('.content');

            if (loaderContainer) {
                loaderContainer.classList.add('hidden'); // Add 'hidden' class
            }

            if (content) {
                content.style.display = 'block'; // Show the content
            }

            // Wait 3 seconds and add 'full-hidden' class to the body
            setTimeout(function () {
                document.body.classList.add('full-hidden');

                // Wait another 3 seconds and add 'after-load' class
                setTimeout(function () {
                    document.body.classList.add('after-load');
                }, 50); // 3-second delay for 'after-load'

            }, 100); // 3-second delay for 'full-hidden'
        }
    }, 50); // Adjust the interval to control the speed of the loader
});
</script>
<!-- end Simple Custom CSS and JS -->
