<?php
/**
 * abe functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package abe
 */

if ( ! defined( '_S_VERSION' ) ) {
	// Replace the version number of the theme on each release.
	define( '_S_VERSION', '1.0.0' );
}

if ( ! function_exists( 'abe_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function abe_setup() {
		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 * If you're building a theme based on abe, use a find and replace
		 * to change 'abe' to the name of your theme in all the template files.
		 */
		load_theme_textdomain( 'abe', get_template_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		/*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
		add_theme_support( 'title-tag' );

		/*
		 * Enable support for Post Thumbnails on posts and pages.
		 *
		 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		 */
		add_theme_support( 'post-thumbnails' );

		// This theme uses wp_nav_menu() in one location.
		register_nav_menus(
			array(
				'menu-1' => esc_html__( 'Primary', 'abe' ),
			)
		);

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support(
			'html5',
			array(
				'search-form',
				'comment-form',
				'comment-list',
				'gallery',
				'caption',
				'style',
				'script',
			)
		);

		// Set up the WordPress core custom background feature.
		add_theme_support(
			'custom-background',
			apply_filters(
				'abe_custom_background_args',
				array(
					'default-color' => 'ffffff',
					'default-image' => '',
				)
			)
		);

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );

		/**
		 * Add support for core custom logo.
		 *
		 * @link https://codex.wordpress.org/Theme_Logo
		 */
		add_theme_support(
			'custom-logo',
			array(
				'height'      => 250,
				'width'       => 250,
				'flex-width'  => true,
				'flex-height' => true,
			)
		);
	}
endif;
add_action( 'after_setup_theme', 'abe_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function abe_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'abe_content_width', 640 );
}
add_action( 'after_setup_theme', 'abe_content_width', 0 );



add_filter( 'wpcf7_form_elements', 'dd_wpcf7_form_elements_replace' );
function dd_wpcf7_form_elements_replace( $content ) {
    // $name == Form Tag Name [textarea* your-message] 
    $name = 'name="text-208"';
    $str_pos = strpos( $content, $name );
    if (false !== $str_pos) {
        $content = substr_replace( $content, ' required ', $str_pos, 0 );
    }
    return $content;
}


/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function abe_widgets_init() {
	register_sidebar(
		array(
			'name'          => esc_html__( 'Sidebar', 'abe' ),
			'id'            => 'sidebar-1',
			'description'   => esc_html__( 'Add widgets here.', 'abe' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
}
add_action( 'widgets_init', 'abe_widgets_init' );

/**
 * Enqueue scripts and styles.
 */
function abe_styles() {
	wp_enqueue_style( 'abe-bootstrap', get_template_directory_uri() . '/css/bootstrap-responsive-tabs.css', array(), _S_VERSION );
	wp_enqueue_style( 'abe-bootstrap-min', get_template_directory_uri() . '/css/bootstrap.min.css', array(), _S_VERSION );
	wp_enqueue_style( 'abe-font-min', get_template_directory_uri() . '/css/font-awesome.min.css', array(), _S_VERSION );
	wp_enqueue_style( 'abe-animate-min', get_template_directory_uri() . '/css/animate.min.css', array(), _S_VERSION );
	wp_enqueue_style( 'abe-animate-slick', get_template_directory_uri() . '/css/slick.css', array(), _S_VERSION );

	wp_enqueue_style( 'abe-fonts','https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap', array(), _S_VERSION );
	
}
add_action( 'wp_enqueue_scripts', 'abe_styles' );
function abe_scripts() {
	wp_enqueue_style( 'abe-style', get_stylesheet_uri(), array(), _S_VERSION );
	wp_style_add_data( 'abe-style', 'rtl', 'replace' );

	wp_enqueue_script( 'abe-jq-min','https://code.jquery.com/jquery-3.6.0.min.js', array(), _S_VERSION, true );
    wp_enqueue_script( 'abe-boot-bundle', get_template_directory_uri() . '/js/bootstrap.bundle.min.js', array(), _S_VERSION, true );
    wp_enqueue_script( 'abe-easing', get_template_directory_uri() . '/js/jquery.easing.min.js', array(), _S_VERSION, true );
	wp_enqueue_script( 'abe-slick', get_template_directory_uri() . '/js/slick.js', array(), _S_VERSION, true );
	wp_enqueue_script( 'abe-main-js', get_template_directory_uri() . '/js/main.js', array(), _S_VERSION, true );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'abe_scripts' );

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
if ( defined( 'JETPACK__VERSION' ) ) {
	require get_template_directory() . '/inc/jetpack.php';
}


add_action('after_setup_theme', 'bootstrap_setup');
if (!function_exists('bootstrap_setup')):
    function bootstrap_setup()
{
        class Bootstrap_Walker_Nav_Menu extends Walker_Nav_Menu
    {
            function start_lvl(&$output, $depth = 0, $args = array())
        {
                $indent = str_repeat("\t", $depth);
                $output .= "\n$indent<ul class=\"dropdown-menu\">\n";
            }

            function start_el(&$output, $item, $depth = 0, $args = array(), $id = 0)
        {
                $indent = ($depth) ? str_repeat("\t", $depth) : '';
                $li_attributes = '';
                $class_names = $value = '';
                $classes = empty($item->classes) ? array() : (array) $item->classes;
                $classes[] = ($args->has_children) ? 'dropdown' : '';
                $classes[] = ($item->current || $item->current_item_ancestor) ? 'active' : '';
                $classes[] = 'nav-item';
                $class_names = join(' ', apply_filters('', array_filter($classes), $item, $args));
                $class_names = ' class="' . esc_attr($class_names) . '"';
                $id = apply_filters('nav_menu_item_id', 'menu-item-' . $item->ID, $item, $args);
                $id = strlen($id) ? ' id="' . esc_attr($id) . '"' : '';
                $output .= $indent . '<li' . $class_names . '>';
                $attributes = !empty($item->attr_title) ? ' title="' . esc_attr($item->attr_title) . '"' : '';
                $attributes .= !empty($item->target) ? ' target="' . esc_attr($item->target) . '"' : '';
                $attributes .= !empty($item->xfn) ? ' rel="' . esc_attr($item->xfn) . '"' : '';
                $attributes .= !empty($item->url) ? ' href="' . esc_attr($item->url) . '"' : '';
                $attributes .= ($args->has_children) ? ' class="dropdown-toggle" data-toggle="dropdown"' : '';
                $item_output = $args->before;
                $item_output .= '<a' . $attributes . ' class="nav-link">';
                $item_output .= $args->link_before . apply_filters('the_title', $item->title, $item->ID) . $args->link_after;
                $item_output .= ($args->has_children) ? ' </a>' : '</a>';
                $item_output .= $args->after;
                $output .= apply_filters('walker_nav_menu_start_el', $item_output, $item, $depth, $args);
            }

            function display_element($element, &$children_elements, $max_depth, $depth = 0, $args, &$output)
        {
                if (!$element) {
                    return;
                }

                $id_field = $this->db_fields['id'];
                //display this element
                if (is_array($args[0])) {
                    $args[0]['has_children'] = !empty($children_elements[$element->$id_field]);
                } else if (is_object($args[0])) {
                $args[0]->has_children = !empty($children_elements[$element->$id_field]);
            }

            $cb_args = array_merge(array(&$output, $element, $depth), $args);
            call_user_func_array(array(&$this, 'start_el'), $cb_args);
            $id = $element->$id_field;
            // descend only when the depth is right and there are childrens for this element
            if (($max_depth == 0 || $max_depth > $depth + 1) && isset($children_elements[$id])) {
                foreach ($children_elements[$id] as $child) {
                    if (!isset($newlevel)) {
                        $newlevel = true;
                        //start the child delimiter
                        $cb_args = array_merge(array(&$output, $depth), $args);
                        call_user_func_array(array(&$this, 'start_lvl'), $cb_args);
                    }
                    $this->display_element($child, $children_elements, $max_depth, $depth + 1, $args, $output);
                }
                unset($children_elements[$id]);
            }
            if (isset($newlevel) && $newlevel) {
                //end the child delimiter
                $cb_args = array_merge(array(&$output, $depth), $args);
                call_user_func_array(array(&$this, 'end_lvl'), $cb_args);
            }
            //end this element
            $cb_args = array_merge(array(&$output, $element, $depth), $args);
            call_user_func_array(array(&$this, 'end_el'), $cb_args);
        }
    }
}
endif;
add_post_type_support( 'page', 'excerpt' );

/*
 * Set post views count using post meta
 */
function setPostViews($postID) {
    $countKey = 'post_views_count';
    $count = get_post_meta($postID, $countKey, true);
    if($count==''){
        $count = 0;
        delete_post_meta($postID, $countKey);
        add_post_meta($postID, $countKey, '0');
    }else{
        $count++;
        update_post_meta($postID, $countKey, $count);
    }
}
add_filter('wpcf7_autop_or_not', '__return_false');
// Remove p tags from category description
remove_filter( 'meta_content', 'wptexturize' );
remove_filter( 'meta_content', 'convert_smilies' );
remove_filter( 'meta_content', 'convert_chars' );
remove_filter( 'meta_content', 'wpautop' );
remove_filter( 'meta_content', 'shortcode_unautop' );
remove_filter( 'meta_content', 'prepend_attachment' );