<?php
/**
 *  Template Name: Front-page 
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package abe
 */

get_header();
?>

<ul class="home-banner">
<?php
 $query = new WP_Query(array('post_type' => 'Sliders' ,'posts_per_page' => -1, 'post_status' => 'publish', 'order' => 'DESC'));
 while ($query->have_posts()): $query->the_post();
 $featured_img_url = get_the_post_thumbnail_url(get_the_ID(), 'full'); 
     ?>
    <li>
        <img src="<?php echo $featured_img_url; ?> ">
        <div class="banner-content">
        <span class="wow"><?php the_title(); ?></span>
        <span class="wow"><?php the_content(); ?></span>
        <a href="#quick-quote" class="quote custom-btn page-scroll">Get a Quote</a>
        </div>
    </li>
    <?php endwhile; ?> <?php wp_reset_postdata();?>
</ul>
            <div class="main-container">
                <div class="home-aboutcontent">
                    <div class="content m-auto">
                        <h5>About Us</h5>
                        <h2><?php echo get_post_meta(14, 'home_page_title', true); ?></h2>
                        <p class="subhead">
							
							<?php 
							echo wp_strip_all_tags(get_post_meta(14, 'home_page_sub_content', true ));
							 
							
							 ?>
							</p>
                        <div class="row ack">
                        <?php
 $query = new WP_Query(array('post_type' => 'about_us' ,'posts_per_page' => -1,'cat'=>-4 , 'post_status' => 'publish', 'order' => 'DESC'));
 while ($query->have_posts()): $query->the_post();
 $featured_img_url = get_the_post_thumbnail_url(get_the_ID(), 'full');
 $img_id = get_post_thumbnail_id(get_the_ID());
 $alt_text = get_post_meta($img_id , '_wp_attachment_image_alt', true);
     
     ?>
                            <div class="col-md-6 col-lg-4">
                                <img src="<?php echo $featured_img_url; ?> " alt="<?php echo $alt_text; ?>">
                                <h3><?php the_title(); ?></h3>
                               <?php the_content(); ?>
                            </div>
                            <?php endwhile; ?> <?php wp_reset_postdata();?>
                        </div>
                        <a href="<?php echo esc_url( get_permalink(14) ); ?>" class="custom-btn">Know More</a>
                    </div>
                </div>
                <div class="home-servicescontent">
                    <section class="features">
                        <div class="container">
                            <div class="content m-auto">
                                <h5>Services</h5>
                                <h2 class="text-center">
                                   <?php echo get_post_meta(17, 'home_page_title', true); ?>
                                </h2>
                                <p class="subhead m-auto"><?php echo wp_strip_all_tags(get_post_meta(17, 'home_page_sub_content', true)); ?></p>
                                <div class="col-md-12">
                                    <ul class="services-list row">
                                    <?php

$query = new WP_Query(array('post_type' => 'what_we_do', 'posts_per_page' => -1,'post_status' => 'publish', 'order' => 'DESC'));
while ($query->have_posts()): $query->the_post();
    // $featured_img_url = get_the_post_thumbnail_url(get_the_ID(), 'full');
    
    ?>
            
                                        <li class="col-md-6 col-lg-4">
                                           <div class="service-card">
                                                <div class="inner">
                                                    <figure class=" <?php echo get_post_meta(get_the_ID(), 'class', true); ?>"></figure>
                                                    <figcaption><?php the_title(); ?></figcaption>
                                                </div>
                                                <div class="card-expander">
                                                    <p><?php echo substr(get_the_excerpt(), 0, 100); ?></p>
                                                    <a href="<?php the_permalink();?>"> <span class="arrow"><img src="<?php echo get_stylesheet_directory_uri(); ?>/images/arrow.png"></span></a>
                                                </div>
                                            </div>
                                        </li>
                                        <?php endwhile; ?> <?php wp_reset_postdata();?>
                                    </ul>

                                    <a href="<?php echo esc_url( get_permalink(17) ); ?>" class="viewall custom-btn m-auto"> View All</a>
                                </div>
                            </div>
                        </div>
                    </section>
                </div>
                <div class="home-portfoliocontent">
                    <section class="features">
                        <div class="container">
                            <div class="content m-auto">
                                <h5>Portfolio</h5>
                                <h2 class="text-center">
                                   <?php echo get_post_meta(20, 'home_page_title', true); ?>
                                </h2>
                                <p class="subhead m-auto"><?php echo wp_strip_all_tags( get_post_meta(20, 'home_page_sub_content', true)); ?></p>
                                <div class="col-md-12">
                                    <ul class="portfolio-list row">
                                        
    <?php

$query = new WP_Query(array('post_type' => 'our_recent_works', 'posts_per_page' => -1, 'post_status' => 'publish', 'order' => 'DESC'));
while ($query->have_posts()): $query->the_post();
    $featured_img_url = get_the_post_thumbnail_url(get_the_ID(), 'full');
    $cat_nam = get_the_category(get_the_ID());
    
if( $cat_nam) {
    $cat_link = get_category_link($cat_nam[0]->cat_ID); // dispaly category link
   
$category_name = $cat_name = $cat_nam[0]->cat_name;
}else {
    $category_name = ''; 
}
    ?>
                                        <li class="col-md-6 col-lg-4">
                                            <div class="portfolio-list-single">
                                                <figure>
                                                    <img src="<?php echo $featured_img_url;  ?>">
                                                </figure>
                                                <figcaption>
                                                    <h3><?php the_title(); ?></h3>
                                                    <p class="catagory"><?php echo $category_name; ?> <a href="" class="arrow"><img src="<?php echo get_stylesheet_directory_uri(); ?>/images/arrow.png"></a> </p>
                                                </figcaption>
                                            </div>
                                        </li>
                                        <?php endwhile; ?> <?php wp_reset_postdata();?>
                                    </ul>
                                    <a href="#" class="viewall custom-btn m-auto"> View All</a>
                                </div>
                            </div>
                        </div>
                    </section>
                </div>
                <div class="home-blogcontent">
                    <section class="features">
                        <div class="container">
                            <div class="content m-auto">
                                <h5>Blogs</h5>
                                <h2 class="text-center">
                                   <?php echo get_post_meta(22, 'home_page_title', true); ?>
                                </h2>
                                <p class="subhead m-auto"><?php echo wp_strip_all_tags(get_post_meta(22, 'home_page_sub_content', true)); ?></p>
                                <div class="col-md-12">
                                    <ul class="blog-list row">
                                    <?php

$query = new WP_Query(array('post_type' => 'post', 'posts_per_page' =>3,'post_status' => 'publish', 'order' => 'DESC'));
while ($query->have_posts()): $query->the_post();
    $featured_img_url = get_the_post_thumbnail_url(get_the_ID(), 'full');
    
    ?>
                                        <li class="col-md-6 col-lg-4">
                                            <div class="blog-list-single">
                                                <figure>
                                                    <img src="<?php echo $featured_img_url; ?>">
                                                </figure>
                                                <figcaption>
                                                    <h3><?php the_title(); ?></h3>
                                                   <p> <?php echo substr(get_the_content(), 0, 100); ?></p>
                                                    <a href="<?php the_permalink();?>" class="readmore">Read More</a>
                                                </figcaption>
                                            </div>
                                        </li>
                                        <?php endwhile; ?> <?php wp_reset_postdata();?>  
                                    </ul>
                                    <a href="<?php echo esc_url( get_permalink(22) ); ?>" class="viewall custom-btn m-auto"> View All</a>
                                </div>
                            </div>
                        </div>
                    </section>
                </div>
                

<?php

get_footer();