<?php
/**
 *  Template Name: About page
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package abe
 */

get_header();
?>
<div class="inner-banner-container">
    <div class="inner-banner">
        <h1>About Us</h1>
        <p class="m-auto"><?php echo get_the_excerpt(get_the_ID());?></p>
    </div>
    </div>
    <div class="main-container about">
        <div class="intro-content">
            <div class="content m-auto">
            <?php the_content(); ?>    
            <div class="row ack">
                <?php
$query = new WP_Query(array('post_type' => 'about_us' ,'posts_per_page' => -1,'cat'=>-4 ,'post_status' => 'publish', 'order' => 'DESC'));
while ($query->have_posts()): $query->the_post();
$featured_img_url = get_the_post_thumbnail_url(get_the_ID(), 'full');
$img_id = get_post_thumbnail_id(get_the_ID());
$alt_text = get_post_meta($img_id , '_wp_attachment_image_alt', true);
?>
                    <div class="col-md-4">
                    <img src="<?php echo $featured_img_url; ?> " alt="<?php echo $alt_text; ?>">
                        <h3><?php the_title(); ?></h3>
                        <?php the_content(); ?>
                    </div>
                    <?php endwhile; ?> <?php wp_reset_postdata();?>
                </div>
            </div>
            <div class="vision">
            <?php
$query = new WP_Query(array('post_type' => 'about_us' ,'cat'=>4 ,'post_status' => 'publish'));
while ($query->have_posts()): $query->the_post(); ?>
                <div class="content m-auto">
                    <h2><?php the_title(); ?></h2>
                    <?php the_content(); ?>
                </div>
                <?php endwhile; ?> <?php wp_reset_postdata();?>
            </div>
        </div>
        <section class="features">
            <div class="container">
                <div class="content m-auto">
                    <h2 class="text-center">
                        Our Company News
                    </h2>
                    <p class="subhead m-auto">Team Abe Media offers best in class digital marketing services within a budget. We deliver result-oriented solutions for your business to grow within a short period of time.</p>
                <div class="col-md-12">
                    <ul class="blog-list row">
                    <?php

$query = new WP_Query(array('post_type' => 'post', 'posts_per_page' => -1,'post_status' => 'publish', 'order' => 'DESC'));
while ($query->have_posts()): $query->the_post();
$featured_img_url = get_the_post_thumbnail_url(get_the_ID(), 'full');
?>
                                <li class="col-md-6 col-lg-4">
                                    <div class="blog-list-single">
                                        <figure>
                                            <img src="<?php echo $featured_img_url; ?>">
                                        </figure>
                                        <figcaption>
                                            <h3><?php the_title(); ?></h3>
                                            <p> <?php echo substr(get_the_content(), 0, 100); ?></p>
                                            <a href="" class="readmore">Read More</a>
                                        </figcaption>
                                    </div>
                                </li>
                                <?php endwhile; ?> <?php wp_reset_postdata();?>
                    </ul>
                </div>
                </div>
                
            </div>
        </section>
<?php get_footer();