<?php
/*
Plugin Name: My Booking Plugin
Description: A simple appointment booking plugin for WordPress.
Version: 1.0
Author: Your Name
*/

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

register_activation_hook(__FILE__, 'my_booking_plugin_create_table');

function my_booking_plugin_create_table() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'bookings';
    $charset_collate = $wpdb->get_charset_collate();

    $sql = "CREATE TABLE $table_name (
        id mediumint(9) NOT NULL AUTO_INCREMENT,
        name varchar(100) NOT NULL,
        email varchar(100) NOT NULL,
        phone varchar(20) NOT NULL,
        date datetime NOT NULL,
        service varchar(100) NOT NULL,
        PRIMARY KEY (id)
    ) $charset_collate;";

    require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
    dbDelta($sql);
}

function my_booking_plugin_form() {
    ob_start(); ?>
    <form id="booking-form" method="post">
        <label for="name">Name:</label>
        <input type="text" name="name" required><br>

        <label for="email">Email:</label>
        <input type="email" name="email" required><br>

        <label for="phone">Phone:</label>
        <input type="text" name="phone" required><br>

        <label for="date">Date:</label>
        <input type="datetime-local" name="date" required><br>

        <label for="service">Service:</label>
        <select name="service" required>
            <option value="Haircut">Haircut</option>
            <option value="Massage">Massage</option>
            <option value="Consultation">Consultation</option>
        </select><br>

        <input type="submit" name="submit_booking" value="Book Now">
    </form>
    <?php
    return ob_get_clean();
}
add_shortcode('booking_form', 'my_booking_plugin_form');

function my_booking_plugin_handle_submission() {
    if (isset($_POST['submit_booking'])) {
        global $wpdb;
        $table_name = $wpdb->prefix . 'bookings';

        $name = sanitize_text_field($_POST['name']);
        $email = sanitize_email($_POST['email']);
        $phone = sanitize_text_field($_POST['phone']);
        $date = sanitize_text_field($_POST['date']);
        $service = sanitize_text_field($_POST['service']);

        $wpdb->insert(
            $table_name,
            array(
                'name' => $name,
                'email' => $email,
                'phone' => $phone,
                'date' => $date,
                'service' => $service,
            )
        );

        echo '<p>Booking successful!</p>';
    }
}
add_action('init', 'my_booking_plugin_handle_submission');

function my_booking_plugin_admin_menu() {
    add_menu_page(
        'Bookings',
        'Bookings',
        'manage_options',
        'my-booking-plugin',
        'my_booking_plugin_admin_page',
        'dashicons-calendar',
        6
    );
}
add_action('admin_menu', 'my_booking_plugin_admin_menu');

function my_booking_plugin_admin_page() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'bookings';
    $bookings = $wpdb->get_results("SELECT * FROM $table_name");

    echo '<div class="wrap"><h1>Bookings</h1>';
    echo '<table class="wp-list-table widefat fixed striped">';
    echo '<thead><tr><th>ID</th><th>Name</th><th>Email</th><th>Phone</th><th>Date</th><th>Service</th></tr></thead>';
    echo '<tbody>';
    foreach ($bookings as $booking) {
        echo '<tr>';
        echo '<td>' . esc_html($booking->id) . '</td>';
        echo '<td>' . esc_html($booking->name) . '</td>';
        echo '<td>' . esc_html($booking->email) . '</td>';
        echo '<td>' . esc_html($booking->phone) . '</td>';
        echo '<td>' . esc_html($booking->date) . '</td>';
        echo '<td>' . esc_html($booking->service) . '</td>';
        echo '</tr>';
    }
    echo '</tbody></table></div>';
}

function my_booking_plugin_scripts() {
    wp_enqueue_style('my-booking-plugin-style', plugins_url('style.css', __FILE__));
    wp_enqueue_script('my-booking-plugin-script', plugins_url('script.js', __FILE__), array('jquery'), null, true);
}
add_action('wp_enqueue_scripts', 'my_booking_plugin_scripts');