<?php
/*
Plugin Name: Event Booking Plugin
Description: A plugin to manage and book events.
Version: 1.0
Author: Your Name
*/
function eb_admin_page() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'events';

    // Handle form submission
    if ($_SERVER['REQUEST_METHOD'] == 'POST') {
        $wpdb->insert(
            $table_name,
            array(
                'title' => sanitize_text_field($_POST['title']),
                'description' => sanitize_textarea_field($_POST['description']),
                'event_date' => sanitize_text_field($_POST['event_date']),
                'location' => sanitize_text_field($_POST['location'])
            )
        );
        echo '<div class="notice notice-success"><p>Event added!</p></div>';
    }

    // Fetch existing events
    $events = $wpdb->get_results("SELECT * FROM $table_name ORDER BY event_date DESC");

    // Event creation form
    echo '
    <h1>Event Booking</h1>
    <h2>Add New Event</h2>
    <form method="post">
        <label for="title">Event Title</label>
        <input type="text" name="title" required>
        <label for="description">Description</label>
        <textarea name="description" required></textarea>
        <label for="event_date">Event Date</label>
        <input type="datetime-local" name="event_date" required>
        <label for="location">Location</label>
        <input type="text" name="location" required>
        <button type="submit">Add Event</button>
    </form>';

    // Display existing events
    if (!empty($events)) {
        echo '<h2>Existing Events</h2>
        <table class="wp-list-table widefat fixed striped">
            <thead>
                <tr>
                    <th>Title</th>
                    <th>Description</th>
                    <th>Date</th>
                    <th>Location</th>
                </tr>
            </thead>
            <tbody>';
        foreach ($events as $event) {
            echo '
            <tr>
                <td>' . esc_html($event->title) . '</td>
                <td>' . esc_html($event->description) . '</td>
                <td>' . esc_html($event->event_date) . '</td>
                <td>' . esc_html($event->location) . '</td>
            </tr>';
        }
        echo '</tbody></table>';
    } else {
        echo '<p>No events found.</p>';
    }
}

add_shortcode('event_listing', 'eb_event_listing');

function eb_event_listing() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'events';
    $events = $wpdb->get_results("SELECT * FROM $table_name ORDER BY event_date DESC");

    if (empty($events)) {
        return '<p>No events found.</p>';
    }

    $output = '<div class="event-listing">';
    foreach ($events as $event) {
        $output .= '
        <div class="event-item">
            <h3>' . esc_html($event->title) . '</h3>
            <p>' . esc_html($event->description) . '</p>
            <p><strong>Date:</strong> ' . esc_html($event->event_date) . '</p>
            <p><strong>Location:</strong> ' . esc_html($event->location) . '</p>
            <a href="?event_id=' . $event->id . '">Book Now</a>
        </div>';
    }
    $output .= '</div>';

    return $output;
}

add_shortcode('booking_form', 'eb_booking_form');

function eb_booking_form() {
    if (!isset($_GET['event_id'])) {
        return '<p>No event selected.</p>';
    }

    $event_id = intval($_GET['event_id']);
    global $wpdb;
    $table_name_events = $wpdb->prefix . 'events';
    $event = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_name_events WHERE id = %d", $event_id));

    if (!$event) {
        return '<p>Event not found.</p>';
    }

    if ($_SERVER['REQUEST_METHOD'] == 'POST') {
        $table_name_bookings = $wpdb->prefix . 'bookings';
        $wpdb->insert(
            $table_name_bookings,
            array(
                'event_id' => $event_id,
                'user_name' => sanitize_text_field($_POST['user_name']),
                'user_email' => sanitize_email($_POST['user_email']),
                'booking_date' => current_time('mysql')
            )
        );
        echo '<div class="notice notice-success"><p>Booking successful!</p></div>';
    }

    // Booking form
    return '
    <div class="booking-form">
        <h2>Book Event: ' . esc_html($event->title) . '</h2>
        <form method="post">
            <label for="user_name">Name</label>
            <input type="text" name="user_name" required>
            <label for="user_email">Email</label>
            <input type="email" name="user_email" required>
            <button type="submit">Book Now</button>
        </form>
    </div>';
}


add_action('wp_enqueue_scripts', 'eb_enqueue_styles');

function eb_enqueue_styles() {
    wp_enqueue_style(
        'event-booking-style',
        plugins_url('style.css', __FILE__)
    );
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $table_name_bookings = $wpdb->prefix . 'bookings';
    $wpdb->insert(
        $table_name_bookings,
        array(
            'event_id' => $event_id,
            'user_name' => sanitize_text_field($_POST['user_name']),
            'user_email' => sanitize_email($_POST['user_email']),
            'booking_date' => current_time('mysql')
        )
    );

    // Send email to user
    $to = sanitize_email($_POST['user_email']);
    $subject = 'Booking Confirmation';
    $message = 'Thank you for booking the event: ' . esc_html($event->title);
    wp_mail($to, $subject, $message);

    // Send email to admin
    $admin_email = get_option('admin_email');
    $subject = 'New Booking';
    $message = 'A new booking has been made for the event: ' . esc_html($event->title);
    wp_mail($admin_email, $subject, $message);

    echo '<div class="notice notice-success"><p>Booking successful!</p></div>';
}
