<?php
/*
Plugin Name: Booking Venue
Description: A simple booking plugin for venues like weddings and parties.
Version: 1.0
Author: Your Name
*/

// Add the main menu item for "Venue"
function booking_venue_admin_menu() {
    add_menu_page('Booking Venue', 'Venue', 'manage_options', 'booking-venue', 'booking_venue_dashboard', 'dashicons-calendar-alt', 6);

    // Add sub-menu for different sections under the "Venue" menu
    add_submenu_page('booking-venue', 'Manage Bookings', 'Manage Bookings', 'manage_options', 'booking-venue-bookings', 'booking_venue_bookings_page');
    add_submenu_page('booking-venue', 'Manage Venues', 'Manage Venues', 'manage_options', 'booking-venue-venues', 'booking_venue_venues_page');
    add_submenu_page('booking-venue', 'Manage Services', 'Manage Services', 'manage_options', 'booking-venue-services', 'booking_venue_services_page');
    add_submenu_page('booking-venue', 'Manage Time Slots', 'Manage Time Slots', 'manage_options', 'booking-venue-timeslots', 'booking_venue_timeslots_page');
}
add_action('admin_menu', 'booking_venue_admin_menu');

// Dashboard page
function booking_venue_dashboard() {
    echo '<h1>Booking Venue Dashboard</h1>';
    echo '<p>Welcome to the venue booking plugin!</p>';
}

// Manage Bookings page
function booking_venue_bookings_page() {
    echo '<h1>Manage Bookings</h1>';
    // List bookings here or show other relevant content
}

// Manage Venues page
function booking_venue_venues_page() {
    echo '<h1>Manage Venues</h1>';
    // List venues or provide the form to add new venues
}

// Manage Services page
function booking_venue_services_page() {
    echo '<h1>Manage Services</h1>';
    // List services or provide the form to add new services
}

// Manage Time Slots page
function booking_venue_timeslots_page() {
    echo '<h1>Manage Time Slots</h1>';
    // List time slots or provide the form to add new time slots
}


function booking_venue_form_shortcode() {
    ob_start(); ?>
    
    <form id="booking-form" action="" method="post">
        <h3>Venue Selection</h3>
        <label for="venue-name">Venue Name:</label>
        <select name="venue-name" id="venue-name">
            <?php
            $venues = get_posts(array('post_type' => 'venue', 'numberposts' => -1));
            foreach ($venues as $venue) {
                echo '<option value="' . $venue->ID . '">' . $venue->post_title . '</option>';
            }
            ?>
        </select>

        <h3>Service Selection</h3>
        <label for="service">Service:</label>
        <select name="service" id="service">
            <?php
            $services = get_posts(array('post_type' => 'abs_service', 'numberposts' => -1));
            foreach ($services as $service) {
                echo "<option value='{$service->ID}'>{$service->post_title}</option>";
            }
            ?>
        </select>

        <h3>Time Slot Selection</h3>
        <label for="time-slot">Time Slot:</label>
        <select name="time-slot" id="time-slot">
            <?php
            $time_slots = get_posts(array('post_type' => 'abs_timeslot', 'numberposts' => -1));
            foreach ($time_slots as $time_slot) {
                $available_from = get_post_meta($time_slot->ID, 'abs_timeslot_available_from', true);
                $available_to = get_post_meta($time_slot->ID, 'abs_timeslot_available_to', true);
                echo "<option value='{$time_slot->ID}'>{$available_from} - {$available_to}</option>";
            }
            ?>
        </select>

        <h3>Booking Date</h3>
        <label for="booking-date">Date:</label>
        <input type="date" name="booking-date" id="booking-date" required />

        <label for="booking-time">Time:</label>
        <input type="time" name="booking-time" id="booking-time" required />

        <input type="submit" value="Book Now" />
    </form>
    
    <?php
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $venue_id = $_POST['venue-name'];
        $service_id = $_POST['service'];
        $time_slot_id = $_POST['time-slot'];
        $booking_date = $_POST['booking-date'];
        $booking_time = $_POST['booking-time'];

        // Save the booking
        $booking = array(
            'post_title'   => 'Booking for ' . get_the_title($venue_id),
            'post_content' => 'Booked for: ' . $booking_date . ' at ' . $booking_time . ', Service: ' . get_the_title($service_id) . ', Time Slot: ' . get_the_title($time_slot_id),
            'post_status'  => 'publish',
            'post_type'    => 'booking',
        );
        $booking_id = wp_insert_post($booking);

        // Save metadata for the booking
        update_post_meta($booking_id, 'venue', $venue_id);
        update_post_meta($booking_id, 'service', $service_id);
        update_post_meta($booking_id, 'time_slot', $time_slot_id);

        // Send confirmation email
        wp_mail('customer@example.com', 'Booking Confirmation', 'Your booking has been confirmed.');
    }
    return ob_get_clean();
}
add_shortcode('booking_form', 'booking_venue_form_shortcode');


// For Services
function abs_service_meta_box($post) {
    ?>
    <h3>Service Details</h3>
    <label for="abs_service_price">Price:</label>
    <input type="number" name="abs_service_price" value="<?php echo esc_attr(get_post_meta($post->ID, 'abs_service_price', true)); ?>" />

    <label for="abs_service_duration">Duration (in minutes):</label>
    <input type="number" name="abs_service_duration" value="<?php echo esc_attr(get_post_meta($post->ID, 'abs_service_duration', true)); ?>" />
    <?php
}


