<?php
/**
 * The template for displaying the header
 *
 * Displays all of the head element and everything up until the "site-content" div.
 *
 * @package WordPress
 * @subpackage Twenty_Fifteen
 * @since Twenty Fifteen 1.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js">
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<!--[if lt IE 9]>
	<script src="<?php echo esc_url( get_template_directory_uri() ); ?>/js/html5.js"></script>
	<![endif]-->
	<?php wp_head(); ?>
    <link rel="shortcut icon" type="image/x-icon" href="<?php bloginfo('template_url');?>/dist/images/fav.png" />

		<style type="text/css">
      body {
          opacity: 1;
          transition: 1.5s opacity;
      }
      body.fade-out {
          opacity: 0;
          transition: none;
      }
    </style>


    <link rel="stylesheet" href="<?php bloginfo('template_url');?>/dist/styles/main.min.css" />


</head>

<body <?php body_class("fade-out"); ?>>
<header class="headroom headroom--pinned">

    <nav class="navbar navbar-expand-lg bg-white">
        <div class="container">
            <a class="navbar-brand" href="/">
                Kiran C K
            </a>

            <button type="button" class="btn" id="menu-btn">
                <img src="<?php bloginfo('template_url');?>/dist/images/menu.svg" alt="menu image">
            </button>
            <?php wp_nav_menu( array('menu' => 'Primary', 'menu_class' => 'navbar-nav ml-auto'  )); ?>

        </div>
    </nav>

		<!-- Menu pops -->
		<div id="menu-pop">
			<div class="wrapper">
			    <div class="mobile-menu-logo">
			        <a class="navbar-brand" href="/"> Kiran C K </a>
			        <a class="close-icon">
                        <img src="<?php bloginfo('template_url');?>/dist/images/close.svg" alt="close image">
                    </a>
			    </div>
				<?php
 				/*
				<a class="mob-brand" href="<?php bloginfo('url');?>">
					Kiran C K
					<span>Design & Art Director</span>
				</a>
				*/
			 ?>

                <?php wp_nav_menu( array('menu' => 'Primary', 'menu_class' => 'navbar-nav ml-auto'  )); ?>

            </div>
		</div>


</header>
