<?php
/**
 * Video Hero pattern content.
 *
 * @package sensei-lms
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

?>
<!-- wp:media-text {"align":"full","mediaPosition":"right","mediaType":"image","mediaWidth":70,"verticalAlignment":"center","imageFill":false,"style":{"color":{"background":"#ffe2c7"}},"className":"is-style-default"} -->
<div class="wp-block-media-text alignfull has-media-on-the-right is-stacked-on-mobile is-vertically-aligned-center is-style-default has-background" style="background-color:#ffe2c7;grid-template-columns:auto 70%"><figure class="wp-block-media-text__media"><img src="<?php echo esc_url( Sensei()->assets->get_image( 'patterns-life-coach-01.jpg' ) ); ?>" alt="" /></figure><div class="wp-block-media-text__content"><!-- wp:spacer {"height":28} -->
<div style="height:28px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:heading {"style":{"color":{"text":"#000000"}}} -->
<h2 class="has-text-color" style="color:#000000"><?php esc_html_e( 'Do What You Always Wanted Today!', 'sensei-lms' ); ?></h2>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"typography":{"lineHeight":1.2,"fontSize":"17px"}},"textColor":"foreground","className":"sensei-content-description"} -->
<p class="has-foreground-color has-text-color sensei-content-description" style="font-size:17px;line-height:1.2"><?php esc_html_e( "Hellen's Life Hacks course will teach you how to get to know yourself and how you can use your natural abilities to finally change your life around and do what you always wanted.", 'sensei-lms' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:sensei-lms/button-take-course -->
<div class="wp-block-sensei-lms-button-take-course is-style-default wp-block-sensei-button wp-block-button has-text-align-left"><button class="wp-block-button__link"><?php esc_html_e( 'Take Course', 'sensei-lms' ); ?></button></div>
<!-- /wp:sensei-lms/button-take-course -->

<!-- wp:spacer {"height":32} -->
<div style="height:32px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer --></div></div>
<!-- /wp:media-text -->

<!-- wp:spacer {"height":28} -->
<div style="height:28px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:heading -->
<h2><?php esc_html_e( 'Make your dream a reality', 'sensei-lms' ); ?></h2>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p><?php esc_html_e( "Hellen's classes offer 1:1 sessions so that she gets to know each of their students. It's not just a group chat, it's you and Hellen, at a personal level. That way you can figure out exactly how to apply her teachings to your personality.", 'sensei-lms' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:spacer {"height":16} -->
<div style="height:16px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:image {"align":"wide","id":1508,"sizeSlug":"large","linkDestination":"none"} -->
<figure class="wp-block-image alignwide size-large"><img src="<?php echo esc_url( Sensei()->assets->get_image( 'patterns-life-coach-02.jpg' ) ); ?>" alt="" class="wp-image-1508"/><figcaption><?php esc_html_e( 'Meeting Helen', 'sensei-lms' ); ?></figcaption></figure>
<!-- /wp:image -->

<!-- wp:spacer {"height":16} -->
<div style="height:16px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:sensei-lms/button-take-course {"align":"center"} -->
<div class="wp-block-sensei-lms-button-take-course is-style-default wp-block-sensei-button wp-block-button has-text-align-center"><button class="wp-block-button__link"><?php esc_html_e( 'Take Course', 'sensei-lms' ); ?></button></div>
<!-- /wp:sensei-lms/button-take-course -->

<!-- wp:group {"align":"wide","layout":{"inherit":false}} -->
<div class="wp-block-group alignwide"><!-- wp:spacer {"height":32} -->
<div style="height:32px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:heading {"textAlign":"left"} -->
<h2 class="has-text-align-left"><?php esc_html_e( "Here's what you'll learn", 'sensei-lms' ); ?></h2>
<!-- /wp:heading -->

<!-- wp:spacer {"height":6} -->
<div style="height:6px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:columns -->
<div class="wp-block-columns"><!-- wp:column -->
<div class="wp-block-column"><!-- wp:image {"id":1512,"sizeSlug":"large","linkDestination":"none"} -->
<figure class="wp-block-image size-large"><img src="<?php echo esc_url( Sensei()->assets->get_image( 'patterns-life-coach-03.jpg' ) ); ?>" alt="" class="wp-image-1512"/></figure>
<!-- /wp:image -->

<!-- wp:heading {"level":4} -->
<h4><?php esc_html_e( 'Discover your inner self', 'sensei-lms' ); ?></h4>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p><?php esc_html_e( "It's important to know who you are before you can get where you want.", 'sensei-lms' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:image {"id":1513,"sizeSlug":"large","linkDestination":"none"} -->
<figure class="wp-block-image size-large"><img src="<?php echo esc_url( Sensei()->assets->get_image( 'patterns-life-coach-01.jpg' ) ); ?>" alt="" class="wp-image-1513"/></figure>
<!-- /wp:image -->

<!-- wp:heading {"level":4} -->
<h4><?php esc_html_e( 'Meet Hellen in your 1:1', 'sensei-lms' ); ?></h4>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p><?php esc_html_e( "You'll get one hour call with Hellen to apply the knowledge you have just acquired.", 'sensei-lms' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:image {"id":1515,"sizeSlug":"large","linkDestination":"none"} -->
<figure class="wp-block-image size-large"><img src="<?php echo esc_url( Sensei()->assets->get_image( 'patterns-life-coach-04.jpg' ) ); ?>" alt="" class="wp-image-1515"/></figure>
<!-- /wp:image -->

<!-- wp:heading {"level":4} -->
<h4><?php esc_html_e( 'Make it actionable', 'sensei-lms' ); ?></h4>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p><?php esc_html_e( "Hellen's course ends with clear action items, so you know what you have to do next.", 'sensei-lms' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->

<!-- wp:spacer {"height":24} -->
<div style="height:24px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:group {"align":"full","style":{"spacing":{"padding":{"top":"6rem","bottom":"6rem"}},"color":{"background":"#ffe2c7","text":"#000000"}},"layout":{"inherit":true}} -->
<div class="wp-block-group alignfull has-text-color has-background" style="background-color:#ffe2c7;color:#000000;padding-top:6rem;padding-bottom:6rem"><!-- wp:media-text {"mediaType":"image","verticalAlignment":"center","imageFill":false} -->
<div class="wp-block-media-text alignwide is-stacked-on-mobile is-vertically-aligned-center"><figure class="wp-block-media-text__media"><img src="<?php echo esc_url( Sensei()->assets->get_image( 'patterns-life-coach-01.jpg' ) ); ?>" alt="" /></figure><div class="wp-block-media-text__content"><!-- wp:heading -->
<h2><?php esc_html_e( 'Meet Hellen', 'sensei-lms' ); ?></h2>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p><?php esc_html_e( 'You will begin by getting to know Hellen, who will also teach you how to learn the best tricks she accumulated throughout her 25+ years of experience.', 'sensei-lms' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:sensei-lms/button-contact-teacher -->
<div class="wp-block-sensei-lms-button-contact-teacher is-style-outline wp-block-sensei-button wp-block-button has-text-align-left"><a class="wp-block-button__link"><?php esc_html_e( 'Contact Hellen', 'sensei-lms' ); ?></a></div>
<!-- /wp:sensei-lms/button-contact-teacher --></div></div>
<!-- /wp:media-text --></div>
<!-- /wp:group -->

<!-- wp:spacer {"height":28} -->
<div style="height:28px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:video {"align":"wide"} -->
<figure class="wp-block-video alignwide"><video controls src="<?php echo esc_url( Sensei()->assets->get_image( 'patterns-video.mp4' ) ); ?>"></video></figure>
<!-- /wp:video -->

<!-- wp:spacer {"height":16} -->
<div style="height:16px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:group -->
<div class="wp-block-group"><!-- wp:paragraph {"align":"center"} -->
<p class="has-text-align-center"><?php esc_html_e( 'TESTIMONIALS', 'sensei-lms' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:heading {"textAlign":"center"} -->
<h2 class="has-text-align-center"><?php esc_html_e( 'What Clients Say', 'sensei-lms' ); ?></h2>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"center"} -->
<p class="has-text-align-center"><?php esc_html_e( 'We place a huge value on strong relationships and have seen the benefit they bring to our business. Customer feedback is vital in helping us to get it right.', 'sensei-lms' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:spacer {"height":16} -->
<div style="height:16px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:image {"align":"center","id":1560,"width":231,"height":345,"sizeSlug":"large","linkDestination":"none","className":"is-style-rounded"} -->
<figure class="wp-block-image aligncenter size-large is-resized is-style-rounded"><img src="<?php echo esc_url( Sensei()->assets->get_image( 'patterns-life-coach-05.jpg' ) ); ?>" alt="" class="wp-image-1560" width="231" height="345"/></figure>
<!-- /wp:image -->

<!-- wp:quote {"align":"center","className":"is-style-large"} -->
<blockquote class="wp-block-quote has-text-align-center is-style-large"><p>“<?php esc_html_e( "Running my own business for a year and couldn't be happier! Thanks, for the course!", 'sensei-lms' ); ?>”</p><cite>— Anna Wong, <em><?php esc_html_e( 'Volunteer', 'sensei-lms' ); ?></em></cite></blockquote>
<!-- /wp:quote --></div>
<!-- /wp:group -->

<!-- wp:spacer {"height":16} -->
<div style="height:16px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:group {"style":{"color":{"text":"#000000","background":"#f6f6f6"},"spacing":{"padding":{"top":"20px","right":"70px","bottom":"20px","left":"70px"}}},"layout":{"inherit":false}} -->
<div class="wp-block-group has-text-color has-background" style="background-color:#f6f6f6;color:#000000;padding-top:20px;padding-right:70px;padding-bottom:20px;padding-left:70px"><!-- wp:spacer {"height":16} -->
<div style="height:16px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:heading {"textAlign":"left"} -->
<h2 class="has-text-align-left"><?php esc_html_e( 'Course Lessons', 'sensei-lms' ); ?></h2>
<!-- /wp:heading -->

<!-- wp:sensei-lms/course-progress /-->

<!-- wp:sensei-lms/course-outline -->
<!-- wp:sensei-lms/course-outline-lesson {"title":"<?php esc_html_e( 'Lesson 1', 'sensei-lms' ); ?>"} /-->

<!-- wp:sensei-lms/course-outline-lesson {"title":"<?php esc_html_e( 'Lesson 2', 'sensei-lms' ); ?>"} /-->

<!-- wp:sensei-lms/course-outline-lesson {"title":"<?php esc_html_e( 'Lesson 3', 'sensei-lms' ); ?>"} /-->
<!-- /wp:sensei-lms/course-outline -->

<!-- wp:sensei-lms/button-take-course -->
<div class="wp-block-sensei-lms-button-take-course is-style-default wp-block-sensei-button wp-block-button has-text-align-left"><button class="wp-block-button__link"><?php esc_html_e( 'Take Course', 'sensei-lms' ); ?></button></div>
<!-- /wp:sensei-lms/button-take-course -->

<!-- wp:spacer {"height":16} -->
<div style="height:16px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer --></div>
<!-- /wp:group -->
