<?php
/*****************************************************************************
 * Thumbnails Helpers 4 Wordpress
 * @author Valentino Aluigi
 * @url http://www.maverick.it/tech
 ****************************************************************************/

/// admin image API
require_once(ABSPATH . '/wp-admin/includes/image.php');

/*
 * Echo a thumbnail of the first image in the current post
 * Use inside the loop
 *
 * @param int $width
 * @param int $height (optional)
 * @param boolean $cut (optional)
 */
function the_thumb($width, $height, $cut = true){
    if(is_null($height)) $height = $width;
    // output the thumb
    $thumb = get_the_thumb($width,$height,$cut);
    if($thumb != '')
        $thumb = '<img width="'.$width.'" height="'.$height.'" src="' . $thumb . '" />';
    echo $thumb;
}

/*
 * Return a thumbnail of the first image in the current post
 * Use inside the loop
 *
 * @param int $width
 * @param int $height (optional)
 * @param boolean $cut (optional)
 */
function get_the_thumb($width, $height, $cut = true){
    if(is_null($height)) $height = $width;

    // read the content
    $content = apply_filters('the_content', get_the_content());
    // extracct the first image
    $img = extract_image($content);
    // return the thumb
    return generate_thumb($img, $width, $height, $cut);
}


/*
 * Generate a thumbnail from an image url and return it's url
 *
 * @param string $img_url absolute url
 * @param int $width
 * @param int $height (optional)
 * @param boolean $cut (optional)
 */
function generate_thumb($img_url, $width, $height, $cut = true){
    // cut the url
    $img = substr($img_url, strpos($img_url, 'wp-content'));

    // resize the image
    $thumb = image_resize($img,$width,$height,$cut);

    return (is_string($thumb)) ? get_bloginfo('wpurl') . '/' .  $thumb : "";
}

/*
 * Extract the first image src inside some html content
 *
 * @param html $content
 */
function extract_image($content){
    $pattern = '~<img (?:.*?)src(?:\s*)=(?:\s*)"(.*?)"(?:.*?)/>~';
    preg_match($pattern, $content, $match);
    return $match[1];
}