<?php
$themename = "Community Innovation";
$shortname = "com";

$fonts = array('Arial' => 'Arial',
			   'Courier New' => 'Courier New',
			   'Georgia' => 'Georgia',
			   'Impact' => 'Impact',
			   'Tahoma' => 'Tahoma',
			   'Times New Roman' => 'Times New Roman',
			   'Trebuchet MS' => 'Trebuchet MS',
			   'Verdana' => 'Verdana'
   			  );

$options = array (
				  
	array(	"type" => "open"),
	
	array(	"name" => "Add/Remove Features",
			"id" => $shortname."_global",
			"options" => array(	'Sitename' => 'Display your blog sitename', 
								'Slogan' => 'Display the slogan beside the sitename', 
								'RSS' => 'Display RSS feed icons and links in header'
								),
			"std" => array('Sitename'),
			"type" => "checkbox_multiple"),
	
	array(	"name" => "Logo",
			"desc" => "Instead of a text sitename, you can upload a custom logo and insert the URL here.",
			"id" => $shortname."_logo",
			"std" => "",
			"type" => "text"),
			
	array(	"name" => "Feedburner RSS Feed",
			"desc" => "Enter your Feedburned RSS feed URL.",
			"id" => $shortname."_feedUrl",
			"std" => "",
			"type" => "text"),

	array(	"name" => "Feedburner Email ID",
			"desc" => "Enter your Feedburner Email Subscription ID.",
			"id" => $shortname."_feedEmailID",
			"std" => "",
			"type" => "text"),

	array(	"name" => "Footer Text",
			"desc" => "Enter any copyright information, legal copy, or comments that you would like to be displayed in the footer.",
			"id" => $shortname."_footerText",
			"std" => '',
			"type" => "textarea"),
	
	array(	"name" => "Scripts (e.g. Google Analytics)",
			"desc" => "Enter any custom scripts, including jQuery scripts to be added to each page.",
			"id" => $shortname."_js",
			"std" => "",
			"type" => "textarea"),
			
	array(	"name" => "Custom Styles (CSS)",
			"desc" => "Enter any custom styles you would like to take priority over the default style sheet.",
			"id" => $shortname."_css",
			"std" => "",
			"type" => "textarea"),
			
	array(	"type" => "close"),	
	array(	"type" => "open"),

	array(	"name" => "Add/Remove/Sort the Navigation",
			"desc" => "Drag and drop to add/remove/sort navigation items.",
			"id" => $shortname."_navsort",
			"options" => "",
			"std" => "Home",
			"type" => "sortnav"),
			
	array(	"name" => "Navigation 'Home' Name",
			"desc" => "Enter the name you would like to be displayed for all 'Home' links.",
			"id" => $shortname."_homeName",
			"std" => "Home",
			"type" => "text"),
	
	array(	"name" => "Drag-n-Drop Panel Settings",
			"id" => $shortname."_navPanel",
			"options" =>  array( 'catNavAdmin' => 'Include Categories in the navigation admin', 
								 'linkNavAdmin' => 'Include Links in the navigation admin'
								 ),
			"std" => array(''),
			"type" => "checkbox_multiple"),
			
	array(	"name" => "Display Children in Dropdown",
			"id" => $shortname."_children",
			"options" =>  array( 'Categories' => 'Allow children of categories to be displayed in a dropdown menu', 
								 'Pages' => 'Allow children of pages to be displayed in a dropdown menu'
								 ),
			"std" => array(''),
			"type" => "checkbox_multiple"),
			
	array(	"type" => "close"),
	array(	"type" => "open"),
	
	array(	"name" => "Add/Remove Features",
			"id" => $shortname."_featured",
			"options" => array(	'Post' => 'Display featured post slider on frontpage',
								'Global Post' => 'Display featured post slider on every page (e.g. archives, search)',
								'Details' => 'Display details such as the post title, categories, comments and date'
								),
			"std" => array(),
			"type" => "checkbox_multiple"),
	
	array(	"name" => "Slider Post Height",
			"desc" => "Enter the height you would like the featured slider and featured thumbnails to be.",
			"id" => $shortname."_featuredHeight",
			"std" => "360",
			"type" => "text"),
			
	array(	"name" => "Featured Posts Number",
			"desc" => "Enter the number of posts you would like to be displayed in the featured slider.",
			"id" => $shortname."_featuredPostsNum",
			"std" => "5",
			"type" => "text"),
			
	array(	"name" => "Transition Speed",
			"desc" => "Enter the speed (in milliseconds) of the fade transition between posts.",
			"id" => $shortname."_featuredSpeed",
			"std" => "1000",
			"type" => "text"),
			
	array(	"name" => "Transition Delay",
			"desc" => "Enter the delay (in milliseconds) between the fade transitions.",
			"id" => $shortname."_featuredDelay",
			"std" => "5000",
			"type" => "text"),
			
	array(	"name" => "Details Position (Vertical)",
			"desc" => "Choose where you would like the post title and details to be displayed vertically.",
			"id" => $shortname."_featuredVertical",
			"options" => array("Top", "Bottom"),
			"std" => "1",
			"type" => "select"),
			
	array(	"name" => "Details Position (Horizontal)",
			"desc" => "Choose where you would like the post title and details to be displayed horizontally.",
			"id" => $shortname."_featuredHorizontal",
			"options" => array("Left", "Right"),
			"std" => "0",
			"type" => "select"),
	
	array(	"type" => "close"),
	array(	"type" => "open"),
	
	array(	"name" => "Add/Remove Features",
			"id" => $shortname."_posts",
			"options" => array(	'Read More' => 'Display a "read more" button under post excerpts',
								'Comments' => 'Display a "view comments" under post excerpts',
								'Thumbnail' => 'Display a generated thumbnail next to post excerpts'
								),
			"std" => array('Read More »'),
			"type" => "checkbox_multiple"),
			
	array(	"name" => "Meta Information",			
			"id" => $shortname."_meta",
			"options" => array(	'Date' => 'Date',
								'Avatar' => 'Avatar',
								'Author' => 'Author', 
								'Categories' => 'Categories', 
								'Tags' => 'Tags'
								),
			"std" => array('Date'),
			"type" => "checkbox_multiple"),
	
	array(	"name" => "Limit Excerpt Text",
			"desc" => "Enter the number of characters you would like to limit the generated excerpts to, if no excerpt is set, and no 'more' tag is used. (0 - no limit)",
			"id" => $shortname."_excerptLimit",
			"std" => "400",
			"type" => "text"),

	array(	"name" => "'Read More' Text",
			"desc" => "Enter the text you would like to be displayed in 'read more' buttons",
			"id" => $shortname."_readMore",
			"std" => "Read More",
			"type" => "text"),
			
	array(	"name" => "Thumbnail Width",
			"desc" => "Enter the width you would like the generated thumbnails to be sized to.",
			"id" => $shortname."_thumbWidth",
			"std" => "180",
			"type" => "text"),
			
	array(	"name" => "Thumbnail Height",
			"desc" => "Enter the height you would like the generated thumbnails to be sized to.",
			"id" => $shortname."_thumbHeight",
			"std" => "180",
			"type" => "text"),
			
	array(	"name" => "Thumbnail Quality",
			"desc" => "Enter the quality you would like the generated thumbnails to be sized with. (100 - best, 0 - worst)",
			"id" => $shortname."_thumbQuality",
			"std" => "100",
			"type" => "text"),
			
	array(	"name" => "Thumbnail Method",
			"desc" => "Choose which method of resizing you would like to be used while resizing the thumbnail. (Crop - recommended, Zoom - retains image aspect ratio)",
			"id" => $shortname."_thumbMethod",
			"options" => array("Crop", "Zoom"),
			"std" => "Crop",
			"type" => "select"),
			
	array(	"name" => "Thumbnail Position",
			"desc" => "Choose which side you would like the post thumbnail to float to.",
			"id" => $shortname."_thumbSide",
			"options" => array("Left", "Right"),
			"std" => "0",
			"type" => "select"),
	
	array(	"type" => "close"),
	array(	"type" => "open"),
	
	array(	"name" => "Add/Remove Features",
			"id" => $shortname."_single",
			"options" => array(	'Thumbnail' => 'Display a generated thumbnail at the top of the page',
								'Social' => 'Display a "social sharing" bar containing icons to share the post',
								'Author' => 'Display an "About the Author" section',
								'Excerpt' => 'Display excerpt displayed on front page',
								'Related' => 'Display a section at the end of the post listing related posts'
								),
			"std" => array('Excerpt'),
			"type" => "checkbox_multiple"),
			
	array(	"name" => "Meta Information",			
			"id" => $shortname."_singleMeta",
			"options" => array(	'Date' => 'Date',
								'Avatar' => 'Avatar',
								'Author' => 'Author', 
								'Categories' => 'Categories', 
								'Tags' => 'Tags'
								),
			"std" => array('Date'),
			"type" => "checkbox_multiple"),
			
	array(	"name" => "Thumbnail Position",
			"desc" => "Choose which side you would like the post thumbnail to float to.",
			"id" => $shortname."_single_thumbSide",
			"options" => array("Left", "Right"),
			"std" => "1",
			"type" => "select"),
			
	array(	"name" => "Number of Related Posts",
			"desc" => "Enter the number of related posts you would like to be listed in the related posts section.",
			"id" => $shortname."_relatedPostsNum",
			"std" => "5",
			"type" => "text"),
			
	array(	"name" => "Related Posts Section Heading",
			"desc" => "Enter the text you would like to appear in the heading of the section listing the related posts.",
			"id" => $shortname."_relatedHeading",
			"std" => "What would you like to do now?",
			"type" => "text"),
			
	array(	"name" => "Related Posts Text",
			"desc" => "Enter the text you would like to appear in the section listing the related posts.",
			"id" => $shortname."_relatedText",
			"std" => "Since you have reached the end of this post, you may be interested in checking out the related posts below, or participate in the discussion by leaving a comment.",
			"type" => "textarea"),
	
	array(	"type" => "close"),
	array(	"type" => "open"),
	
	
			
	array(	"name" => "Body Line Height",
			"desc" => "Enter the line height for all general body text.",
			"id" => $shortname."_bodyLine",
			"std" => "20",
			"type" => "text"),
			
	
			
	
			
	array(	"name" => "Secondary Highlight Color",
			"desc" => "Choose the color you would like to be used for secondary highlights.",
			"id" => $shortname."_secondaryHighlightColor",
			"std" => "#995555",
			"type" => "colorpicker"),
			

			
	array(	"name" => "Heading 2 Font",
			"desc" => "Choose the font you would like to be used for all &lt;h2&gt; tags.",
			"id" => $shortname."_h2Font",
			"options" => $fonts,
			"std" => "Arial",
			"type" => "select"),
			
	array(	"name" => "Heading 2 Color",
			"desc" => "Choose the color you would like to be used for all &lt;h2&gt; tags.",
			"id" => $shortname."_h2Color",
			"std" => "#333333",
			"type" => "colorpicker"),
			
	array(	"name" => "Heading 2 Size",
			"desc" => "Enter the size for all &lt;h2&gt; tags.",
			"id" => $shortname."_h2Size",
			"std" => "22",
			"type" => "text"),
			
	array(	"name" => "Heading 3 Font",
			"desc" => "Choose the font you would like to be used for all &lt;h3&gt; tags.",
			"id" => $shortname."_h3Font",
			"options" => $fonts,
			"std" => "Georgia",
			"type" => "select"),
			
	array(	"name" => "Heading 3 Color",
			"desc" => "Choose the color you would like to be used for all &lt;h3&gt; tags.",
			"id" => $shortname."_h3Color",
			"std" => "#444444",
			"type" => "colorpicker"),
			
	array(	"name" => "Heading 3 Size",
			"desc" => "Enter the size for all &lt;h3&gt; tags.",
			"id" => $shortname."_h3Size",
			"std" => "18",
			"type" => "text"),
			
	array(	"name" => "Heading 4 Font",
			"desc" => "Choose the font you would like to be used for all &lt;h4&gt; tags.",
			"id" => $shortname."_h4Font",
			"options" => $fonts,
			"std" => "Arial",
			"type" => "select"),
			
	array(	"name" => "Heading 4 Color",
			"desc" => "Choose the color you would like to be used for all &lt;h4&gt; tags.",
			"id" => $shortname."_h4Color",
			"std" => "#777777",
			"type" => "colorpicker"),
			
	array(	"name" => "Heading 4 Size",
			"desc" => "Enter the size for all &lt;h4&gt; tags.",
			"id" => $shortname."_h4Size",
			"std" => "16",
			"type" => "text"),
			
	array(	"name" => "Heading 5 Font",
			"desc" => "Choose the font you would like to be used for all &lt;h5&gt; tags.",
			"id" => $shortname."_h5Font",
			"options" => $fonts,
			"std" => "Arial",
			"type" => "select"),
			
	array(	"name" => "Heading 5 Color",
			"desc" => "Choose the color you would like to be used for all &lt;h5&gt; tags.",
			"id" => $shortname."_h5Color",
			"std" => "#333333",
			"type" => "colorpicker"),
			
	array(	"name" => "Heading 5 Size",
			"desc" => "Enter the size for all &lt;h5&gt; tags.",
			"id" => $shortname."_h5Size",
			"std" => "14",
			"type" => "text"),
			
	array(	"name" => "Heading 6 Font",
			"desc" => "Choose the font you would like to be used for all &lt;h6&gt; tags.",
			"id" => $shortname."_h6Font",
			"options" => $fonts,
			"std" => "Arial",
			"type" => "select"),
			
	array(	"name" => "Heading 6 Color",
			"desc" => "Choose the color you would like to be used for all &lt;h6&gt; tags.",
			"id" => $shortname."_h6Color",
			"std" => "#995555",
			"type" => "colorpicker"),
			
	array(	"name" => "Heading 6 Size",
			"desc" => "Enter the size for all &lt;h6&gt; tags.",
			"id" => $shortname."_h6Size",
			"std" => "12",
			"type" => "text"),
	
	array(	"type" => "close")
	
);



function mytheme_add_admin() {	

    global $themename, $shortname, $options, $com_misc;
	
    if ( $_GET['page'] == basename(__FILE__) ) {
    
        if ( 'save' == $_REQUEST['action'] ) {  
				$homeName = get_option('com_homeName');

                foreach ($options as $value) {
					if( isset( $_REQUEST[ $value['id'] ] ) ) { 
						if ($value['type'] == 'textarea' || $value['type'] == 'sortnav') $_REQUEST[$value['id']] = stripslashes($_REQUEST[$value['id']]);						
						if ($value['id'] == 'com_navsort' && ($_REQUEST['com_homeName'] !== $homeName) ) { 
							$nav = get_option('com_navsort'); $nav = str_replace($homeName,$_REQUEST['com_homeName'],$nav); update_option('com_navsort',$nav);
						} else { update_option( $value['id'], $_REQUEST[ $value['id'] ]  ); }
					
					} else { delete_option( $value['id'] );	}
					
					if ($value['type'] == 'checkbox_multiple' && is_array($value['std']) && get_option($value['id'].'_status') !== 'saved') update_option( $value['id'].'_status', 'saved');				
			    }
				
				$anchor = ($_REQUEST['anchor'] !== '')?$_REQUEST['anchor']:'';
                
				header("Location: themes.php?page=theme-options.php&saved=true".$anchor);
                die;

        } else if( 'reset' == $_REQUEST['action'] ) {

            foreach ($options as $value) {
                delete_option( $value['id'] ); 			
				
				$$value['id'] = $value['std']; 
				if ($value['type'] == 'checkbox_multiple' && is_array($value['std'])) { 
					update_option( $value['id'].'_status', 'unsaved'); 
					update_option( $value['id'], $value['std']); 
				}
				if (($value['type'] == 'text' || $value['type'] == 'colorpicker' || $value['type'] == 'upload') && $value['std'] !== '') 
					update_option( $value['id'], $value['std']);
			}

            header("Location: themes.php?page=theme-options.php&reset=true");
            die;

        }
    }
		
    add_theme_page($themename." Settings", "Theme Settings", 'edit_themes', basename(__FILE__), 'mytheme_admin');

}

function mytheme_admin() {
	
	global $themename, $shortname, $options, $com_home_name, $com_navPanel, $wpdb, $navstyles; 
	
    if ( $_REQUEST['saved'] ) echo '<div id="message" class="updated fade"><p><strong>'.$themename.' settings saved</strong></p></div>';
    if ( $_REQUEST['reset'] ) echo '<div id="message" class="updated fade"><p><strong>'.$themename.' settings reset</strong></p></div>';

?>

<link rel="stylesheet" media="screen" type="text/css" href="<?php bloginfo('template_directory'); ?>/js/colorpicker/css/colorpicker.css" />
<link rel="stylesheet" media="screen" type="text/css" href="<?php bloginfo('template_directory'); ?>/admin.css" />

<script type="text/javascript" src="<?php bloginfo('template_directory'); ?>/js/tools.js"></script>
<script type="text/javascript" src="<?php bloginfo('template_directory'); ?>/js/colorpicker/js/colorpicker.js"></script>
<script type="text/javascript" src="<?php bloginfo('template_directory'); ?>/js/colorpicker/js/eye.js"></script>
<script type="text/javascript" src="<?php bloginfo('template_directory'); ?>/js/colorpicker/js/utils.js"></script>

<div class="wrap">
<h2>Community Innovation Theme Settings (ver 1.0)</h2><br />

<div id="container">

<ul class="tabs"> 
    <li><a href="#general" class="general">General</a></li>
    <li><a href="#navigation" class="navigation">Navigation</a></li>
	<li><a href="#featured" class="featured">Featured Post</a></li>
	<li><a href="#posts" class="posts">Posts</a></li>
	<li><a href="#single" class="single">Single Post</a></li>
	<li><a href="#typography" class="typography">Typography</a></li>
</ul> 
<form method="post" id="comsettings">
<!-- tab "panes" --> 
<div class="panes"> 

<?php 
$num = 0;
foreach ($options as $value) {
	
	switch ( $value['type'] ) {
	
		case "open": ?>
		
        <div>        
        
		<?php break; case "close": ?>
		
        </div>
                
        <!-- Text -->
		<?php break; case 'text': ?>
		
			<div class="option_wrapper">
			
				<div class="left"><?php echo $value['name']; ?></div>
				
				<div class="right">
				
					<input style="width: 420px;" name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" type="<?php echo $value['type']; ?>" value="<?php if ( get_settings( $value['id'] ) != "") { echo get_settings( $value['id'] ); } /* else { echo $value['std']; } */ ?>" />
					<small><?php echo $value['desc']; ?></small>
			
				</div>
			
			</div>
		
		<!-- Textarea -->
		<?php break; case 'textarea': ?>
        
			<div class="option_wrapper">
			
				<div class="left"><?php echo $value['name']; ?></div>
				
				<div class="right">
				
					<textarea name="<?php echo $value['id']; ?>" style="width:420px; height:200px;" type="<?php echo $value['type']; ?>" cols="" rows=""><?php if ( get_settings( $value['id'] ) != "") { echo get_settings( $value['id'] ); } else { echo $value['std']; } ?></textarea>
					<small><?php echo $value['desc']; ?></small>
				
				</div>
				
			</div>

		<!-- Select Menu -->
		<?php break; case 'select': ?>
		
			<div class="option_wrapper">
			
				<div class="left"><?php echo $value['name']; ?></div>
				
				<div class="right">
				
					<select style="width: 420px;" name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>"><?php foreach ($value['options'] as $key => $option) { ?><option<?php if ( get_settings($value['id']) == $key) { echo ' selected="selected"'; } elseif (!get_settings($value['id']) && $key == $value['std']) { echo ' selected="selected"'; } ?> value="<?php echo $key; ?>"><?php echo $option; ?></option><?php } ?></select>
					<small><?php echo $value['desc']; ?></small>
				
				</div>
				
			</div>	

		<!-- Select Multiple Menu -->
		<?php break; case 'select_multiple': ?>
		
			<div class="option_wrapper">
			
				<div class="left"><?php echo $value['name']; ?></div>
				
				<div class="right">
				
					<select style="width: 420px; height: 100px;" name="<?php echo $value['id']; ?>[]" multiple="multiple" id="<?php echo $value['id']; ?>">
					<?php foreach ($value['options'] as $key => $option) { echo '<option value="'.$key.'"'; if (get_settings( $value['id'])) { if (in_array($key, get_settings( $value['id'] ))) { echo ' selected="selected"'; } } elseif ($key == $value['std']) { echo ' selected="selected"'; } echo '>'.$option. '</option>'; } ?></select>
					<small><?php echo $value['desc']; ?></small>
					
				</div>
				
			</div>

		<!-- Checkbox -->
		<?php break; case "checkbox": ?>
		
            <div class="option_wrapper">
			
				<div class="left"><?php echo $value['name']; ?></div>
				
				<div class="right">
				
					<?php if (get_settings($value['id'])) { $checked = "checked=\"checked\""; } else { $checked = ""; } ?>
					<input type="checkbox" name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" value="true" <?php echo $checked; ?> />
					<label for="<?php echo $value['id']; ?>"><?php echo $value['desc']; ?></label>       
					
				</div>
				
			</div>
           
        <!-- Multiple Checkboxes -->    
        <?php break; case "checkbox_multiple": ?>
		
			<div class="option_wrapper">
		
				<div class="left"><?php echo $value['name']; ?></div>
				
				<div class="right"><ul>
				
				<?php $i = 0; 
				
				foreach ($value['options'] as $key => $option) { 
				
					$checked = ""; 
					if (get_settings($value['id'])) { if ( in_array($key, get_settings( $value['id'] ))) $checked = "checked=\"checked\""; } elseif ( in_array($key, $value['std']) && get_option($value['id'].'_status') !== 'saved') $checked = "checked=\"checked\""; ?>
					
					<li><input type="checkbox" name="<?php echo $value['id']; ?>[]" id="<?php echo $value['id']; ?>-<?php echo $key; ?>" value="<?php echo $key; ?>" <?php echo $checked; ?> />
					<label for="<?php echo $value['id']; ?>-<?php echo $key; ?>"><?php echo $option; ?></label></li>
					
				<?php $i++; } ?></ul></div>
			
			</div>
            
        <!-- Colorpicker -->    
        <?php break; case "colorpicker": ?>
		
            <div class="option_wrapper">
		
				<div class="left"><?php echo $value['name']; ?></div>
				
				<div class="right">
				
					<script language="javascript">
					
						(function($){
							var initLayout = function() {		
								$('#colorSelector-<?php echo $value['id']; ?>').ColorPicker({
									color: '<?php if ( get_settings( $value['id'] ) != "") { echo get_settings( $value['id'] ); } else { echo $value['std']; } ?>',
									onShow: function (colpkr) {
										$(colpkr).fadeIn(500);
										return false;
									},
									onHide: function (colpkr) {
										$(colpkr).fadeOut(500);
										return false;
									},
									onChange: function (hsb, hex, rgb) {
										$('#colorSelector-<?php echo $value['id'] ?> div').css('backgroundColor', '#' + hex);
										$("#<?php echo $value['id']; ?>").attr('value', '#' + hex);								
									}
								});
							};	
							EYE.register(initLayout, 'init');
						})(jQuery)
						
					</script>   
					
					<div id="colorContainer" style="float: left;"><div id="colorSelector-<?php echo $value['id']; ?>"><div style="background-color: <?php if ( get_settings( $value['id'] ) != "") { echo get_settings( $value['id'] ); } else { echo $value['std']; } ?>"></div></div></div>
					<input name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" type="hidden" value="<?php if ( get_settings( $value['id'] ) != "") { echo get_settings( $value['id'] ); } else { echo $value['std']; } ?>" />
					<small style="float: left; margin-left: 10px;"><?php echo $value['desc']; ?></small>
				
				</div>
			
			</div>
            
        <!-- Upload -->
        <?php break; case 'upload': ?>
        
			<div class="option_wrapper">
		
				<div class="left"><?php echo $value['name']; ?></div>
				
				<div class="right">   
				
					<p><?php $needlePos = strpos($value['std'], 'file:'); if((string)$needlePos === (string)0) { ?>
					<a class="button thickbox" href="media-upload.php?post_id=<?php echo str_replace('file:', '', $value['std']); ?>&amp;TB_iframe=true&width=640&height=500" id="add_image" title="File Upload">Click here to upload</a>
					<?php } else { ?><a class="button thickbox" href="media-upload.php?post_id=<?php echo $value['std']; ?>&amp;type=image&amp;TB_iframe=true&width=640&height=500" id="add_image" title="Image Upload">Click here to upload</a><?php } ?></p>
					<small><?php echo $value['desc']; ?></small>
        
				</div>
				
			</div>

		<!-- Navigation Sorter -->
		<?php break; case 'sortnav': ?>

		<div class="option_wrapper">
		
			<?php $home = "Home"; $multipleNav = false;	$nav = get_option(com_navsort); $numNavBars = count(explode(',,',$nav))+1; ?>
			
			<span class="heading"><?php echo $value['name']; ?></span>
                <td>
				
				<script type="text/javascript">
				
					jQuery(document).ready(function($){
					
						function enableSortable() {
							var i=0, lists = '';
							$(".connectedSortable").each(function (i) {
								i++;
								if(i>1) lists += ','; 
								lists += '#' + $(this).attr("id");
							});						
							
							$(lists).sortable({
								connectWith: '.connectedSortable',
								update : function () {								
									updateNavlist();
								}
							}).disableSelection();
						}					
						enableSortable();
						
						function updateNavlist() {
							var navlist = '';						
							$(".navbar").each(function (i) {
								i++;
								navName = '';							
								if (i>1) navName = ',,name:' + $(this).attr("id") + ',';
								navlist += navName + $(this).sortable('toArray');
							});						

							$("#<?php echo $value['id']; ?>").attr('value', navlist);	
						}
						
						$('.addnav').click(function() {						
							var numNavs = ($('.connectedSortable').size()+1);
							var navName = Prompt.show("Navigation Name","Type Name Here");
							if (navName==null || navName=='') return true;
							navName = navName.replace(/ /g,'-');
							$("#navadmin").append('<span><div class="clear">&nbsp;</div><h5 id="'+navName+'-heading" class="navbarHeading editnavname">'+navName+'</h5><img id="'+navName+'-remove" class="removenav" src="<?php bloginfo('template_directory'); ?>/images/minus.gif"  title="Remove this navigation bar" /></span><div class="clear"></div><ul id="'+navName+'" class="connectedSortable navbar">');	
							enableSortable();
						});
											
						$(".removenav").live("click", function() {
							var navName = $(this).attr("id");
							navName = navName.replace('-remove','')
							$('ul#'+navName).remove();
							$(this).parent().remove();
							updateNavlist();
						});

						$(".editnavname").live("click", function() {
							var navName = $(this).attr("id");
							navName = navName.replace('-heading','')
							var newNavName = Prompt.show("Navigation Name",navName);						
							if (navName == newNavName || newNavName == '' || newNavName == null) return true;
							else {
								$(this).attr("id",newNavName+"-heading");
								$(this).text(newNavName);
								$("#"+navName+"-remove").attr("id", newNavName);
								$("ul#"+navName).attr("id", newNavName);
								updateNavlist();
							}
						});

					});		
				
				</script>
                 
                <span id="navadmin">
                <h5 class="navbarHeading">To add/remove/sort the navigation, simply drag and drop the links to where you would like them.</h5><div class="clear"></div>
				<h4 class="sectionHeading">Available Links</h4>
                <ul id="navlist1" class="connectedSortable">
                <h4 class="sectionHeading light">Pages</h4>
                <?php				
				echo '<li id="'.$home.'" class="ui-state-default">'.$home.'</li>';
				foreach (get_pages() as $com_page) {
					echo '<li id="'.$com_page->post_title.'" class="ui-state-default">'.$com_page->post_title.'</li>';				
				}
				
				if (in_array('catNavAdmin',$com_navPanel)) {
				
					echo '<div class="clear">&nbsp;</div><h4 class="sectionHeading light">Categories</h4>';
					foreach (get_categories('hide_empty=0') as $cat) {
							echo '<li id="cat_'.$cat->cat_name.'" class="ui-state-default">'.$cat->cat_name.'</li>';
					}
				}
				
				if (in_array('linkNavAdmin',$com_navPanel)) {
				
					echo '<div class="clear">&nbsp;</div><h4 class="sectionHeading light">Links</h4>';
					
					$taxonomy = 'link_category';				  
					$args ='';
					$terms = get_terms( $taxonomy, $args );
					if ($terms) {
						foreach($terms as $term) {
						  if ($term->count > 0) {
							echo '<li id="linkcat_'.$term->name.' _ '.$term->term_id.'" class="ui-state-default">'.$term->name.'</li>';							
						  }
						}
					}
					
					foreach (get_bookmarks() as $link) {
							echo '<li id="link_'.$link->link_name.' _ '.$link->link_id.'" class="ui-state-default">'.$link->link_name.'</li>';
					}
				}
				?>
                
                <div id="addNavs"></div>
                </ul>
                <div class="clear"></div> 
				<h4 class="sectionHeading">Navigation</h4>
                <ul id="mainnav" class="connectedSortable navbar">                	
                	
                    <?php					
					$newNavItems = '';
					$i = 0;
					if ($nav) {						
						$navItems = explode(',',$nav);						
						foreach ($navItems as $navItem) {
							
							if($navItem == '' && $multipleNav) {
								$navName = str_replace('name:', '', $navItems[($i+1)]);
								echo '</ul><span><div class="clear">&nbsp;</div><h5 id="'.$navName.'-heading" class="navbarHeading editnavname">'.$navName.'</h5><img id="'.$navName.'-remove" class="removenav" src="'.get_bloginfo('template_directory').'/images/minus.gif"  title="Remove this navigation bar" /></span><div class="clear"></div><ul id="'.$navName.'" class="connectedSortable navbar">';								
								
								$newNavItems .= ',';								
							
							} elseif(strstr($navItem,'name:')) {
								$newNavItems .= ','.$navItem;
								
							} else {
						
								$needlePos = strpos($navItem, 'cat_');
								$needlePos2 = strpos($navItem, $home);
								$needlePos3 = strpos($navItem, 'link_');
								$needlePos4 = strpos($navItem, 'linkcat_');
								$needlePos5 = strpos($navItem, 'cats_');
								if((string)$needlePos === (string)0) {					
									$catName = str_replace('cat_', '', $navItem);
									$catID = get_cat_ID($catName);
									if ($catID) { echo '<li id="'.$navItem.'" class="ui-state-default">'.$catName.'</li>'; $newNavItems .= ','.$navItem;  }
								} elseif((string)$needlePos3 === (string)0) {					
									$linkNav = str_replace('link_', '', $navItem);
									$linkNav = explode(' _ ',$linkNav);	
									$link = get_bookmark((int)$linkNav[1]);								
									if ($link->link_id) {
										$navItem = 'link_'.$link->link_name.' _ '.$link->link_id;
										echo '<li id="'.$navItem.'" class="ui-state-default">'.$link->link_name.'</li>'; 
										$newNavItems .= ','.$navItem;
									}								
								} elseif((string)$needlePos4 === (string)0) {					
									$linkNav = str_replace('linkcat_', '', $navItem);
									$linkNav = explode(' _ ',$linkNav);	
									$navItem = 'linkcat_'.$linkNav[0].' _ '.$linkNav[1];
									echo '<li id="'.$navItem.'" class="ui-state-default">'.$linkNav[0].'</li>'; 
									$newNavItems .= ','.$navItem;
	
								} elseif((string)$needlePos2 === (string)0) {
									echo '<li id="'.$home.'" class="ui-state-default">'.$home.'</li>'; $newNavItems .= ','.$home;
								} elseif((string)$needlePos5 === (string)0) {
									$catName = str_replace('cats_', '', $navItem);
									echo '<li id="'.$navItem.'" class="ui-state-default">'.$catName.'</li>'; $newNavItems .= ','.$navItem;
								} else {
									$pageID = $wpdb->get_var("SELECT ID FROM $wpdb->posts WHERE post_title = '".addslashes($navItem)."' AND post_type = 'page' AND post_status = 'publish'");
									if ($pageID) { echo '<li id="'.$navItem.'" class="ui-state-default">'.$navItem.'</li>'; $newNavItems .= ','.$navItem; }
								}
								
							} 
							$i++;
						} // End foreach
					} else { echo '<li id="'.$home.'" class="ui-state-default">'.$home.'</li>'; $newNavItems = ','.$home; }
					?>                        
                </ul>
                </span>            
				
				<input type="hidden" name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" value="<?php echo substr($newNavItems,1); ?>" />
			
		</div>
            
		<?php 
		break;	
    }
	if ($options[$num+1]['type']!=='close' &&  $value['type']!=='close' && $options[$num]['type']!=='open' &&  $value['type']!=='open') echo '<tr><td colspan="2" style="margin-bottom:5px;border-bottom:1px solid #dddddd;">&nbsp;</td></tr><tr><td colspan="2">&nbsp;</td></tr>';
	$num++;
}
?>

	</div>

	<div id="buttons">
	
		<p class="submit">
		
			<input onclick="return setAnchor();" name="save" type="submit" value="Save changes" class="comBtn" />    
			<input type="hidden" name="action" value="save" />
			<input id="anchor" type="hidden" name="anchor" value="" />
			
		</p>
		
		</form>

		<form method="post">

			<p class="submit">
				<input name="reset" type="submit" value="Reset" class="comBtn" />
				<input type="hidden" name="action" value="reset" />
			</p>
			
		</form>
		
	</div>

</div>

<!-- Javascript for the tabs -->
<script type="text/javascript">
jQuery(document).ready(function($) {
	$("ul.tabs").tabs("div.panes > div").history();
});

function setAnchor() { document.getElementById('anchor').value = location.hash; }
</script>

<?php
}

wp_enqueue_script('jquery');

if (is_admin()) {
	if (function_exists('wp_enqueue_style')) {
		wp_enqueue_script('jquery-ui-core');
		wp_enqueue_script('jquery-ui-sortable');		
		wp_enqueue_script('thickbox');
		wp_enqueue_style('thickbox');
	}
	add_action('admin_menu', 'mytheme_add_admin');
}

global $options;

foreach ($options as $value) {
    if ( get_settings( $value['id'] ) === FALSE) { 
		
		if ($value['type'] == 'checkbox_multiple') { 
		
			if (is_array($value['std']) && get_option($value['id'].'_status') !== 'saved') {
				update_option( $value['id'].'_status', 'unsaved'); 
				update_option( $value['id'], $value['std']); 
				$$value['id'] = $value['std']; 
			} else $$value['id'] = array();
			
		} else {			
			update_option( $value['id'], $value['std']);
			$$value['id'] = $value['std']; 
		}
		
	} else 
		$$value['id'] = get_settings( $value['id'] );
}
?>