<?php

global $featured_ID;

// Enables post images
if (function_exists('add_theme_support')) {
	add_theme_support('post-thumbnails');
}

// Register sidebars
if(function_exists('register_sidebar')){ register_sidebar(array('name' => 'Sidebar')); } 
if(function_exists('register_sidebar')){ register_sidebar(array('name' => 'Footer')); } 

// Excerpt ending
function new_excerpt_more($excerpt) {
	return str_replace('[...]', '...', $excerpt);
}
add_filter('wp_trim_excerpt', 'new_excerpt_more');

// Removes 'more' jump
function remove_more_jump_link($link) { 

	$offset = strpos($link, '#more-');
	
	if ($offset) {
		$end = strpos($link, '"',$offset);
	}
	if ($end) {
		$link = substr_replace($link, '', $offset, $end-$offset);
	}
	
return $link;

}

add_filter('the_content_more_link', 'remove_more_jump_link');

// Thumbnail Post Meta Information
function com_meta() {

	global $com_meta;

	if (in_array('Date', $com_meta)) { echo '<div class="date"><span class="day">'; the_time('d'); echo '</span><span class="month">'; the_time('M'); echo '</span><span class="year">'; the_time('o'); echo '</span></div>'; }
	if (in_array('Avatar', $com_meta)) { echo '<div class="avatar">'; echo get_avatar(get_the_author_meta('user_email'),'80'); echo '</div>'; }
	if (in_array('Author', $com_meta) || in_array('Category', $com_meta) || in_array('Tags', $com_meta)) {
		echo '<div class="meta">';				
			if (in_array('Author', $com_meta)) { echo '<h6>Author</h6><span>'; echo the_author_link(); echo '</span>'; }
			if (in_array('Categories', $com_meta)) { echo '<h6>Category</h6><span>'; echo the_category(', '); echo '</span>'; }
			if (in_array('Tags', $com_meta)) { echo '<h6>Tags</h6><span>'; the_tags(''); echo '</span>'; }
		echo '</div>';
	}
}

// Single Post Meta Information
function com_singleMeta() {

	global $com_singleMeta;

	if (in_array('Date', $com_singleMeta)) { echo '<div class="date"><span class="day">'; the_time('d'); echo '</span><span class="month">'; the_time('M'); echo '</span><span class="year">'; the_time('o'); echo '</span></div>'; }
	if (in_array('Avatar', $com_singleMeta)) { echo '<div class="avatar">'; echo get_avatar(get_the_author_meta('user_email'),'80'); echo '</div>'; }
	if (in_array('Author', $com_singleMeta) || in_array('Category', $com_singleMeta) || in_array('Tags', $com_singleMeta)) {
		echo '<div class="meta">';		
			if (in_array('Author', $com_singleMeta)) { echo '<h6>Author</h6><span>'; echo the_author_link(); echo '</span>'; }
			if (in_array('Categories', $com_singleMeta)) { echo '<h6>Category</h6><span>'; echo the_category(', '); echo '</span>'; }
			if (in_array('Tags', $com_singleMeta) && get_the_tags('') != '') { echo '<h6>Tags</h6><span>'; the_tags(''); echo '</span>'; }
		echo '</div>';
	}
}

// Dynamic Page Titles
function com_title() {
	
	if ( is_single() ) { wp_title(''); echo (' | '); bloginfo('name');
	} else if ( is_page() || (is_page() && is_paged()) ) { if ( is_front_page() ) { bloginfo('name'); } else { bloginfo('name'); echo (' | '); wp_title(''); if(is_paged()) echo ' |  page '.get_query_var('paged'); }
	} else if ( is_author() ) { bloginfo('name'); wp_title(' | '. 'Author');		  
	} else if ( is_category() ) { bloginfo('name'); wp_title(' | '.'Browsing the category '.' ');	
	} else if ( is_tag() ) { bloginfo('name'); echo (' | '.'Browsing the tag archive for'.' '); wp_title('');	
	} else if ( is_archive() ) { bloginfo('name'); echo (' | '.'Browsing the archive for'.' '); wp_title('');	
	} else if ( is_search() ) { bloginfo('name'); echo (' | '.'Search Results for '.' '.$s);	 
	} else if ( is_404() ) { bloginfo('name'); echo (' | '.'404 Error - Page Not Found');		  
	} else if ( is_home() ) { bloginfo('name'); echo (' | '); bloginfo('description'); if(is_paged()) echo ' |  page '.get_query_var('paged');		
	} else { bloginfo('name');		  
	}
}

// Header Site Meta
function com_header_meta() { 

	global $post;
	
	if(is_home()) { echo '<meta name="description" content="'.get_bloginfo('description').'" />'; } 
	if(is_single()) { 
		echo '<meta name="keywords" content="';
		$metatags = get_the_tags($post->ID);
		if ($metatags) { 
			$i = 0;
			foreach ($metatags as $tagpost) {
				$mymetatag = apply_filters('the_tags',$tagpost->name);
				$keyword = ($mymetatag);
				if ($i > 0) echo ", "; $i++;
				echo $keyword;
		}
		} else {
			$i = 0;
			foreach((get_the_category()) as $category) { 
				if ($i > 0) echo ", "; $i++;
				echo $category->cat_name;			
			}		
		} 	
		echo '" />';
	}
	if(is_search()) { echo '<meta name="robots" content="noindex, nofollow" />'; }
		
}

// Related Posts
function com_related_posts() {

	global $post, $id, $com_relatedPostsNum;
	
	$saved_post = $post;
	$tags = wp_get_post_tags($post->ID);
	
	if ($com_relatedPostsNum == "") $com_relatedPostsNum = 5;
	
	if ($tags) {
		$tag_ids = array();
		foreach($tags as $individual_tag) $tag_ids[] = $individual_tag->term_id;
	}
	
	if ($tags) {
	
		$args = array(	'tag__in' => $tag_ids,
						'post__not_in' => array($post->ID),
						'showposts'=> $com_relatedPostsNum,
						'caller_get_posts'=> 1 
					 );	  
					 
		$relatedposts = new WP_Query($args);
		
		if ($relatedposts->have_posts()) {
		
			echo '<ul id="related-posts">';
			
			while ($relatedposts->have_posts()) : $relatedposts->the_post();
			
				echo '<li><a href="'.get_permalink().'"><span>'.get_the_title().'<small>Posted on '.get_the_time('F j, Y').'</small></span>'; com_thumb('related'); echo '</a></li>';

			endwhile;
			
			echo '</ul>';
			
		}	
		
		echo '<div class="clear"></div>';		
		$post = $saved_post;	  
		$id = $post->ID;
	
	}
	
}

// Post Excerpt
function com_excerpt() {

	global $post, $com_excerptLimit;
	
	if ($post->post_excerpt) {
	
		$text = get_the_excerpt();
		if (is_single()) echo '<p class="excerpt">'.$text.'</p>'; else echo '<p>'.$text.'</p>';
		
	} elseif (!is_single()) {
	
		if (strpos($post->post_content, '<!--more-->')) $com_excerptLimit = strpos($post->post_content, '<!--more-->');
		$text = get_the_content();		
		$text = strip_shortcodes($text);
		$text = strip_tags($text);
		$text = substr($text, 0, $com_excerptLimit);
		$text = substr($text, 0, strripos($text, " "));
		echo '<p>'.$text.'</p>';
		
	}
}

// Post Preview Thumbnail
function com_thumb($type = 'thumbnail') {

	global $post, $posts, $com_thumbWidth, $com_thumbHeight, $com_thumbMethod, $com_thumbQuality, $com_thumbSide, $com_single_thumbSide, $com_featuredHeight, $com_featuredQuality;
	
	$com_dir = get_bloginfo('template_directory'); 
	$com_dir .= '/timthumb.php?src='; 
	$meta_thumb = get_post_meta($post->ID, 'post_image_value', true);
	
	$attachments = get_posts(array('post_type' => 'attachment', 'numberposts' => 1, 'post_status' => null, 'post_parent' => $post->ID));
	
	if ($type == 'featured') $call = the_post_thumbnail('featured'); if ($type == 'tiny') $call = the_post_thumbnail('tiny'); else $call = the_post_thumbnail('thumbnail');
	
	if ($attachments) { 
	
		foreach ($attachments as $attachment) $image = wp_get_attachment_image_src($attachment->ID, 'full', false);
		
	} else {
	
		ob_start();
		ob_end_clean();
		$output = preg_match_all('/<img.+src=[\'"]([^\'"]+)[\'"].*>/i', $post->post_content, $matches);
		$image[0] = $matches [1] [0];
		
	}
	
	if ($com_thumbMethod == "Crop") $method == 'true';
	
	set_post_thumbnail_size(180, 180, true);
	add_image_size('thumbnail', $com_thumbWidth, $com_thumbHeight, $method);
	add_image_size('featured', 670, $com_featuredHeight, true);
	add_image_size('tiny', 40, 40, true);
	
	if ($type == 'featured') {
	
		$w = '&amp;w=670';
		$zc = '&amp;zc=1';
		if ($com_featuredHeight != 0) { $h = '&amp;h=' . $com_featuredHeight; } else { $h = '&amp;h=360'; }
		if ($com_featuredQuality >= 0 && $com_featuredQuality <= 100) { $q = '&amp;q=' . $com_featuredQuality; } else { $q = '&amp;q=100'; }
	
	} elseif ($type == 'related') {
	
		$w = '&amp;w=90'; $h = '&amp;h=90'; $zc = '&amp;zc=1'; $q = '&amp;q=100';
		
	} elseif ($type == 'tiny') {
	
		$w = '&amp;w=40'; $h = '&amp;h=40'; $zc = '&amp;zc=1'; $q = '&amp;q=100';
	
	} else {
	
		if ($com_thumbWidth != 0 && $com_thumbWidth < 549) { $w = '&amp;w=' . $com_thumbWidth; } else { $w = '&amp;w=180'; }
		if ($com_thumbHeight != 0) { $h = '&amp;h=' . $com_thumbHeight; } else { $h = '&amp;h=180'; }
		if ($com_thumbMethod == 0) { $zc = '&amp;zc=1'; } else { $zc = '&amp;zc=0'; } 
		if ($com_thumbQuality >= 0 && $com_thumbQuality <= 100) { $q = '&amp;q=' . $com_thumbQuality; } else { $q = '&amp;q=100'; }
		
	}
	
	if ($meta_thumb || $image[0] || has_post_thumbnail()) {
	
		if ($type == 'tiny') { 
		
			echo '<div class="tiny-thumb">'; 
			
		} elseif (is_single() && $type == 'thumbnail') { 
		
			if ($com_single_thumbSide == 0) echo '<div class="thumb left">'; 
			else echo '<div class="thumb right">'; 
			
		} elseif ($type == 'thumbnail') { 
		
			if ($com_thumbSide == 0) echo '<div class="thumb left">'; else echo '<div class="thumb right">'; 
			
		}
		
		if ($type != 'related' && !has_post_thumbnail()) echo '<a href="'.get_permalink().'" title="'.get_the_title().'">';

		if (has_post_thumbnail()) { echo $call; } 
		
		elseif ($meta_thumb !== "") { echo '<img src="'.$com_dir.$meta_thumb.$w.$h.$zc.$q.'" alt="'.get_the_title().' Thumbnail" />'; } 
		
		elseif ($image[0] !== "") { echo '<img src="'.$com_dir.$image[0].$w.$h.$zc.$q.'" alt="'.get_the_title().' Thumbnail" />'; }
		
		if ($type != 'related' && !has_post_thumbnail()) echo '</a>';
		
		if ($type != 'featured' && $type != 'related') echo '</div>'; 
	
	}
	
}

// 'The Loop' Posts
function com_loop() {

	global $post, $posts, $com_posts, $featured_ids, $com_readMore;
	
	if (!$com_readMore) $com_readMore = 'Read More';
	
	if (is_home()) {
		
		query_posts(array('post__not_in' => $featured_ids, 'paged' => get_query_var('paged')));
		
		if (have_posts()) {
		
			while (have_posts()) { 
					
				the_post();

				echo '<div class="post" id="post-'.get_the_ID().'"><div class="details">';

				com_meta();

				echo '</div><div class="content">';

				if (in_array('Thumbnail', $com_posts)) { com_thumb(); }

				echo '<div class="block"><h1><a href="'.get_permalink().'" title="'.get_the_title().'">'.get_the_title().'</a></h1>';

				com_excerpt();

				if (in_array('Read More', $com_posts)) { echo '<a href="'.get_permalink().'" class="default">'.$com_readMore.'</a>'; }
				
				if (in_array('Comments', $com_posts)) { echo '<a href="'.get_comments_link().'" class="default">'; comments_number('Leave a Comment', 'View Comments (1)', 'View Comments (%)'); echo '</a>'; }
				
				echo '</div></div></div>';
			
			}

		} else { echo '<div class="post" style="background:none;padding-bottom:0;"><div class="content"><p>There are no posts found.</p></div></div>'; }
		
	} else {
	
		if (have_posts()) { 
	
			while(have_posts()) : the_post();

				echo '<div class="post" id="post-'.get_the_ID().'"><div class="details">';

				com_meta();

				echo '</div><div class="content">';

				if (in_array('Thumbnail', $com_posts)) { com_thumb(); }

				echo '<div class="block"><h1><a href="'.get_permalink().'" title="'.get_the_title().'">'.get_the_title().'</a></h1>';

				com_excerpt();

				if (in_array('Read More', $com_posts)) { echo '<a href="'.get_permalink().'" class="default">'.$com_readMore.'</a>'; }
				
				if (in_array('Comments', $com_posts)) { echo '<a href="'.get_comments_link().'" class="default">'; comments_number('Leave a Comment', 'View Comments (1)', 'View Comments (%)'); echo '</a>'; }
				
				echo '</div></div></div>';
			
			endwhile;

		} else { echo '<div class="post" style="background:none;padding-bottom:0;"><div class="content"><p>There are no posts found.</p></div></div>'; }
		
	}

}

// Featured Slider Posts
function com_featured() {

	global $post, $posts, $com_featuredPostsNum, $featured_ids, $com_featured;

	$args = array(	'meta_value'=> 'on', 
					'meta_key'=> 'featured_value', 
					'post_type' => 'post', 
					'post_status' => 'publish', 
					'posts_per_page' => $com_featuredPostsNum, 
					'caller_get_posts'=> 1 
				); 
				
	$featured = null; $featured = new WP_Query($args); 
	
	if ($featured->have_posts()) { 
	
		echo '<div id="featured"><ul>';
	
		while ($featured->have_posts()) : $featured->the_post(); $featured_ids[] = get_the_ID();
		
			echo '<li><span class="top"></span><span class="left"></span><span class="right"></span><span class="bottom"></span>';
				
			if (in_array('Details', $com_featured)) {
			
				echo '<div class="desc"><h1><a href="'.get_permalink().'" title="'.get_the_title().'">'.get_the_title().'</a></h1><small>';
				
				
				echo '</a> '.get_the_time('F j, Y').'</small></div>';
				
			}
			
			com_thumb('featured');
			
			echo '</li>';
		
		endwhile;
		
		echo '</ul></div>';
	
	} wp_reset_query();
	
}

// Removes pages from search
function com_search_filter($query) {
	if ($query->is_search) { $query->set('post_type', 'post'); }
	return $query;
}

add_filter('pre_get_posts','com_search_filter');

// Navigation Widget
class NavigationWidget extends WP_Widget {
    
    function NavigationWidget() {
		$widget_ops = array('classname' => 'widget_nav', 'description' => 'Tabbed widget displaying lists of navigation items');
		$this->WP_Widget('nav', "Navigation", $widget_ops);
    }

    function widget($args, $instance) {
	
        extract( $args );
        
		echo '<li id="nav_tabs" class="tab">';
		
		echo $before_title . $instance['title'] . $after_title;
		
		echo '<div class="box"><ul class="tabs"><li><a href="#categories">Categories</a></li><li><a href="#archives">Archives</a></li><li><a href="#pages">Pages</a></li></ul><div class="tab_container"><div id="categories" class="tab_content"><ul class="double-col">';
		
		wp_list_categories('title_li=&orderby=name&hide_empty=0&hierarchical=0');
		
		echo '</ul></div><div id="archives" class="tab_content"><ul class="double-col">';
		
		wp_get_archives('type=monthly');
		
		echo '</ul></div><div id="pages" class="tab_content"><ul class="double-col">';

		wp_list_pages($page_include.'title_li=');
		
		echo '</ul></div></div></div></li>';
		
    }

    function update($new_instance, $old_instance) {				
        return $new_instance;
    }

    function form($instance) {		
	
        $title = esc_attr($instance['title']);
		
        ?>
            <p><label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:'); ?> <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" /></label></p>
			
        <?php 
    }

}

add_action('widgets_init', create_function('', 'return register_widget("NavigationWidget");'));

// Community Widget
class CommunityWidget extends WP_Widget {
    
    function CommunityWidget() {
		$widget_ops = array('classname' => 'widget_community', 'description' => 'Tabbed widget displaying sorted lists of posts');
		$this->WP_Widget('community', "Community", $widget_ops);
    }

    function widget($args, $instance) {
	
		if ($instance['recentposts'] || $instance['editors']) {
	
			extract( $args );
			
			$com_dir = get_bloginfo('template_directory'); 
			$com_dir .= '/timthumb.php?src='; 
			
			echo '<li id="com_tabs" class="tab">'.$before_title.$instance['title'].$after_title.'<div class="box"><ul class="tabs">';
			
			if ($instance['recentposts']) echo '<li><a href="#recent">Recent Posts</a></li>';
			if ($instance['editors']) echo '<li><a href="#choice">Editor&#39;s Choice</a></li>';
			
			echo '</ul><div class="tab_container">';
			
			if ($instance['recentposts']) { 
			
				echo '<div id="recent" class="tab_content"><ul class="single-col">';
				
				$args = array('post_type' => 'post', 'post_status' => 'publish', 'posts_per_page' => $instance['recentpostsNum'], 'caller_get_posts'=> 1 ); $recent_query = null; $recent_query = new WP_Query($args); 
				
				if($recent_query->have_posts()) : while ($recent_query->have_posts()) : $recent_query->the_post();
				
				global $com_date_format;
				
				echo '<li>'; com_thumb('tiny'); echo '<div class="block"><a class="bold" href="'.get_permalink().'" title="'.get_the_title().'">'.get_the_title().'</a><small>Posted on '; echo the_time('F j, Y'); echo '</small></div></li>';
				
				endwhile;
				
				else :
				
					echo '<li>There were no posts found.</li>';
				
				endif;
				
				wp_reset_query();
				
				echo '</ul></div>';
			
			} 
			
			if ($instance['editors']) { 
			
				echo '<div id="choice" class="tab_content"><ul class="single-col">';
				
				$args = array('meta_value'=> 'on', 'meta_key'=> 'post_editors_choice_value', 'post_type' => 'post', 'post_status' => 'publish', 'posts_per_page' => $instance['editorsNum'], 'caller_get_posts'=> 1 ); $editors_choice = null; $editors_choice = new WP_Query($args); 
				
				if($editors_choice->have_posts()) : while ($editors_choice->have_posts()) : $editors_choice->the_post();
			
				global $post, $com_date_format;
				ob_start();
				ob_end_clean();
				$output = preg_match_all('/<img.+src=[\'"]([^\'"]+)[\'"].*>/i', $post->post_content, $matches);
				$image[0] = $matches [1] [0];
				
				echo '<li>'; com_thumb('tiny'); echo '<div class="block"><a class="bold" href="'.get_permalink().'" title="'.get_the_title().'">'.get_the_title().'</a><small>Posted on '; echo the_time('F j, Y'); echo '</small></div></li>';
				
				endwhile;
				
				else :
				
					echo '<li>There were no posts found.</li>';
				
				endif;
				
				wp_reset_query();
				
				echo '</ul></div>';
			
			}
			
			echo '</div></div></li>';
		
		}
		
    }

    function update($new_instance, $old_instance) {				
        return $new_instance;
    }

    function form($instance) {		
	
        $title = esc_attr($instance['title']);
		$recentposts = esc_attr($instance['recentposts']);
		$recentpostsNum = esc_attr($instance['recentpostsNum']);
		$editors = esc_attr($instance['editors']);
		$editorsNum = esc_attr($instance['editorsNum']);
		
        ?>
            <p><label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:'); ?> <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" /></label></p>
			<p><input id="<?php echo $this->get_field_id('recentposts'); ?>" name="<?php echo $this->get_field_name('recentposts'); ?>" type="checkbox" value="true"  <?php echo empty($recentposts)?'':'checked=checked'; ?> /> <label for="<?php echo $this->get_field_id('recentposts'); ?>"><?php echo 'Recent Posts'; ?></label></p>
			<p><label for="<?php echo $this->get_field_id('recentpostsNum'); ?>"><?php _e('Number of Recent Posts:'); ?> <input class="widefat" id="<?php echo $this->get_field_id('recentpostsNum'); ?>" name="<?php echo $this->get_field_name('recentpostsNum'); ?>" type="text" value="<?php echo $recentpostsNum; ?>" /></label></p>
			<p><input id="<?php echo $this->get_field_id('editors'); ?>" name="<?php echo $this->get_field_name('editors'); ?>" type="checkbox" value="true"  <?php echo empty($editors)?'':'checked=checked'; ?> /> <label for="<?php echo $this->get_field_id('editors'); ?>"><?php echo "Editor's Choice Posts"; ?></label></p>
			<p><label for="<?php echo $this->get_field_id('editorsNum'); ?>"><?php _e("Number of Editor's Choice Posts:"); ?> <input class="widefat" id="<?php echo $this->get_field_id('editorsNum'); ?>" name="<?php echo $this->get_field_name('editorsNum'); ?>" type="text" value="<?php echo $editorsNum; ?>" /></label></p>
			
        <?php 
    }

}

add_action('widgets_init', create_function('', 'return register_widget("CommunityWidget");'));

// Navigation
function com_navigation($navName = '', $navStyle = '') {

	global $wpdb, $wp_query, $com_features, $com_navpages, $com_navcats, $com_children, $com_homeName, $com_navsort, $com_nav_style;
	$dropdown = false;
	$first = true;
	$navalign= 'alignright';
	
	$navItems = explode(',,',$com_navsort);
	
	if (in_array('Pages', $com_children) || in_array('Categories', $com_children)) $dropdown = true;
	
	if ($navName !== '' && strstr($com_nav_style,'navbar')) echo '<div class="clear"></div>';    
	?><ul><?php		
			if ($navName !== '') {				
				array_shift($navItems);				
				foreach ($navItems as $nav) {
					$needlePos = stripos($nav, 'name:'.$navName.',');
					if((string)$needlePos === (string)0) {						
						$navItems = explode(',',$nav);
						array_shift($navItems);
						break;
					}
				}
			} else {				
				$navItems = explode(',',$navItems[0]);
			}
			
			$first = $navItems[0];
			$last = end($navItems);            
			foreach ($navItems as $navItem) {				
				$needlePos = strpos($navItem, 'cat_');
				$needlePos2 = strpos($navItem, 'cats_');
				$needlePos3 = strpos($navItem, 'link_');
				$needlePos4 = strpos($navItem, 'linkcat_');
				if((string)$needlePos === (string)0) {					
					$catName = str_replace('cat_', '', $navItem);					
					$catID = get_cat_ID($catName);
					$term = get_terms('category', 'number=1&name__like='.$catName);
					if ($term) {						
						$currentPageItem = (in_category($catID) && !is_home());
						echo '<li class="'.(is_category($catID) ?'current_page_item':'').'"><a href="'.get_category_link($catID).'">'.$catName.'</a>';
						
						if (in_array('Categories', $com_children)) {
							$children = get_categories('child_of='.$catID);
							if ($children) {
								echo '<ul>';
								wp_list_categories('hide_empty=0&title_li=&child_of='.$catID);
								echo '</ul>';
							}
						}					
						echo '</li>';
					}
					
				} elseif((string)$needlePos2 === (string)0) {					
					$catName = str_replace('cats_', '', $navItem);
					echo '<li><a href="#">'.$catName.'</a><ul>';					
					foreach (get_categories() as $cat) {
						$catID = $cat->cat_ID;
						echo '<li class="'.(is_category($catID)?'current_page_item':'').'"><a href="'.get_category_link($catID).'">'.$cat->cat_name.'</a>';						
						
						if (in_array('Categories', $com_children)) {
							$children = wp_list_categories('echo=0&title_li=&child_of='.$catID);
							if ($children && !strpos($children,'No categories')) {
								echo '<ul>';
								wp_list_categories('hide_empty=0&title_li=&child_of='.$catID);
								echo '</ul>';
							}
						}					
						echo '</li>';
					}					
					echo '</ul></li>';					
					
				} elseif ((string)$needlePos3 === (string)0) {
					$linkNav = str_replace('link_', '', $navItem);
					$linkNav = explode(' _ ',$linkNav);
					$link = get_bookmark((int)$linkNav[1]);	
					if ($link->link_id) echo '<li><a href="'.$link->link_url.'">'.$link->link_name.'</a></li>';
					
				} elseif ((string)$needlePos4 === (string)0) {
					$linkNav = str_replace('linkcat_', '', $navItem);
					$linkNav = explode(' _ ',$linkNav);					
					echo '<li><a href="#">'.$linkNav[0].'</a>';					
					echo '<ul>'; wp_list_bookmarks('category='.$linkNav[1].'&title_li=&categorize=0'); echo '</ul>';			
					echo '</li>';
					
				} else {
					$pageName = $navItem;
					
					if ($pageName == $com_homeName) {
                    ?><li class="<?php if (is_front_page()) echo 'current_page_item'; ?>"><a href="<?php echo get_option('home'); ?>"><?php echo $com_homeName; ?></a></li><?php 		} else {
				  		$staticPage = $wp_query->get_queried_object();						
						$query = "SELECT * FROM $wpdb->posts WHERE post_title = '".addslashes($pageName)."' AND post_type = 'page' AND post_status = 'publish'";
						$page = $wpdb->get_results($query);
						$page = apply_filters('get_pages', $page);

						if ($page) {
							$pageID = $page[0]->ID;							
							$cat = trim(get_post_meta($pageID, 'category',true));
							$currentPageItem = in_category($cat); 
							
							echo '<li class="'.( is_page($pageID) || ($staticPage->ID == $pageID || $currentPageItem)?'current_page_item':'').'"><a href="'.get_page_link($pageID).'">'.$pageName.'</a>';
							
							if (in_array('Pages', $com_children)) {
								$children = wp_list_pages('echo=0&title_li=&child_of='.$pageID);
								if ($children) {
									echo '<ul>';
									wp_list_pages('title_li=&child_of='.$pageID);
									echo '</ul>';
								}
							}					
							echo '</li>';
						}
			  		}
					
				}
			}
			
	?></ul>
<?php
}

?>