<?php if (!empty($_SERVER['SCRIPT_FILENAME']) && 'comments.php' == basename($_SERVER['SCRIPT_FILENAME'])) die ('Please do not load this page directly. Thanks!'); 
if ( post_password_required() ) { echo 'This post is password protected. Enter the password to view comments.'; return; } ?>

<?php $altcomment = 'alt'; ?>

<div id="comments">

	<div class="content">

		<h2 class="no-space">Discussion</h2>

		<?php if ($post->comment_status == 'open') : ?>

			<p><strong><?php comments_number('No responses', 'One response', '% responses'); ?> to "<?php the_title(); ?>"</strong></p>
			
		<?php else : ?>

			<strong><?php comments_number('No responses', 'One response', '% responses'); ?> to "<?php the_title(); ?>". Comments are closed for this post.</strong>

		<?php endif; ?>
		
		<?php if ( have_comments() ) { ?>
		
		<div class="navigation comment-nav">
	
			<div class="alignleft default"><?php previous_comments_link() ?></div>
			<div class="alignleft default"><a href="#respond">Leave a Comment</a></div>
			<div class="alignright default"><?php next_comments_link() ?></div>
		
		</div>
		
		<?php } else { if ($post->comment_status == 'open') : ?>

			<p>There are no comments yet, add one below.</p>

		<?php else : ?>

			<p>Comments are closed at this time.</p>
			
		<?php endif; } ?>
		
	</div>

<?php if ( have_comments() ) : ?>
	
	<ul class="commentlist">
	
		<?php wp_list_comments('type=comment&avatar_size=80'); ?>
		<?php wp_list_comments('type=pings'); ?>
		
	</ul>
	
	<div class="content">
	
		<div class="navigation comment-nav">
		
			<div class="alignleft default"><?php previous_comments_link() ?></div>
			<div class="alignright default"><?php next_comments_link() ?></div>
			
		</div>
		
	</div>
	
<?php endif; ?>

</div>

<?php if ($post->comment_status == 'open') : ?>

	<div class="content">

		<h2 class="no-space">Leave a Comment</h2>

		<?php if ( get_option('comment_registration') && !$user_ID ) : ?>
		
			<p>You must be <a href="<?php bloginfo('url'); ?>/wp-login.php?redirect_to=<?php the_permalink(); ?>">logged in</a> to post a comment.</p>
		
		<?php else : ?>
		
		<div id="respond">
		
			<form action="<?php bloginfo('url'); ?>/wp-comments-post.php" method="post" id="commentform">
			
				<?php comment_id_fields(); ?>
			
				<?php if ( $user_ID ) : ?>
				
					<p>You are currently logged in as <a href="<?php echo get_option('siteurl'); ?>/wp-admin/profile.php"><?php echo $user_identity; ?></a> <a href="<?php echo get_option('siteurl'); ?>/wp-login.php?action=logout" title="Log out of this account">(Logout)</a>.</p>

				<?php else : ?>
				
					<p><label for="author"><small>Name <?php if ($req) echo "(required)"; ?></small></label>
					<input type="text" name="author" id="author" class="textfield input" value="<?php echo $comment_author; ?>" size="50" onclick="this.value='';" /></p>
					
					<p><label for="email"><small>E-mail (will not be published) <?php if ($req) echo "(required)"; ?></small></label>
					<input type="text" name="email" id="email" class="textfield input" value="<?php echo $comment_author_email; ?>" size="50" onclick="this.value='';" /></p>
					
					<p><label for="url"><small>Website (optional)</small></label>
					<input type="text" name="url" id="url" class="textfield input" value="<?php echo $comment_author_url; ?>" size="50" onclick="this.value='';" /></p>
				
				<?php endif; ?>
				
					<p><textarea name="comment" id="data" cols="85" rows="10" tabindex="4" class="textfield message input" ></textarea></p>
					
					<input name="submit" type="submit" id="submit" tabindex="5" value="Submit Comment" />
					<div id="cancel-comment-reply"><?php cancel_comment_reply_link() ?></div>
				
				<?php do_action('comment_form', $post->ID); ?>
			
			</form>
			
		</div>
		
		<?php endif; ?>
		
	</div>

<?php endif; ?>