<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;

/* @var $this yii\web\View */
/* @var $model app\models\User */

$this->title = "Office & Plan";
$this->params['breadcrumbs'][] = ['label' => 'Users', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;

// stop($planDetails->id);
?>
<div class="user-view">
    
    <?php
        if($officeDetails->plan_status==0)
        {
            ?>
         <div class="alert alert-danger col-md-12">
            <strong>Warning! <br>Your Plan expired on <?= $officeDetails->plan_expiry; ?>,</strong>  <br>Please renew your plan to continue
        </div>
        <?php
        }
        ?>
    <div class="row">
      
     <div class="col-md-6">
        <div class="box">
            <div class="box-body">
                <table class="table table-striped table-bordered">
                        <tr>
                            <td>Office Name </td>
                            <td>:</td>
                            <td><?= $officeDetails->name ?></td>
                        </tr>
                        <tr>
                            <td>Plan Expiry </td>
                            <td>:</td>
                            <td><?= $officeDetails->plan_expiry ?></td>
                        </tr>
                        <tr>
                            <td>Office Address </td>
                            <td>:</td>
                            <td><?= $officeDetails->address ?></td>
                        </tr>
                        <tr>
                            <td>Country </td>
                            <td>:</td>
                            <td><?= $officeDetails->country ?></td>
                        </tr>
                        <tr>
                            <td>State </td>
                            <td>:</td>
                            <td><?= $officeDetails->state ?></td>
                        </tr>
                </table>
            </div>
        </div>
     </div>
    
    <div class="col-md-6">
        <div class="box">
            <div class="box-body">
                <table class="table table-striped table-bordered">
                        <tr>
                            <td>Plan Name </td>
                            <td>:</td>
                            <td><?= $planDetails->name ?></td>
                        </tr>
                        
                        <tr>
                            <td>Plan Features </td>
                            <td>:</td>
                            <td><?php  
                            
                            $desc = explode(PHP_EOL, $planDetails->other_features);
                        foreach ($desc as $k => $v) {
                            ?>
                                <?= $v; ?><br>
                                <?php
                        }?>
                            </td>
                        </tr>
                        
                        <tr>
                            <td>Monthly Price</td>
                            <td>:</td>
                            <td><?= $planDetails->m_price ?></td>
                        </tr>
                        <tr>
                            <td>Yearly Price </td>
                            <td>:</td>
                            <td><?= $planDetails->y_price ?></td>
                        </tr>
                </table>
                <?php
                $date1=date_create(date('Y-m-d'));
                $date2=date_create($officeDetails['plan_expiry']);
                $diff=date_diff($date1,$date2);
                $renewaldays=$diff->format("%a");
                if ($renewaldays <= 5) {
                    ?>
                    <?php $form = ActiveForm::begin(['action' => ['payment/index'], 'options' => ['method' => 'post']]) ?>
                    <input type="hidden" name="mode" value="Instamojo">
                    <input type="hidden" name="id" value="<?php echo $planDetails->id ?>">
                    <input type="hidden" name="type" value="plan">
                    <input type="hidden" name="site_id" value="0">
                    <?php
                    if(($planDetails->id !==1) && ($planDetails->id !==2) )
                    {
                    ?>
                        <input type="radio" name="planType" value="monthly" required=""> Monthly 
                        <input type="radio" name="planType" value="yearly"> Yearly
                    <?php
                    }
                    else
                    {
                    ?>
                        <input type="radio" name="planType" value="yearly" required=""> Yearly
                    <?php
                    }
                    ?>
                    
                    
                    <button type="submit" class="link-btn01">Pay Now</button>
                    <?php ActiveForm::end(); ?>
                    <?php
                }
                ?>
            </div>
        </div>
     </div>
    </div>
    
    <?php //pre($officeDetails) ?>
    <?php // pre($planDetails) ?>

    


</div>
