<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\widgets\Pjax;
/* @var $this yii\web\View */
/* @var $searchModel app\models\UserSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Users';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="user-index">

    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <p>
        <?= Html::a('Create User', ['create'], ['class' => 'btn btn-success']);
        if (!$resetButton) {
            $url = (isset($_GET['id'])) ? '/user?id=' . $_GET['id'] : '/user'
            ?>
            <?php echo Html::a('Reset Filter', [$url], ['class' => 'btn btn-info']); ?><br>
    <?php } ?>
    </p>
    <div class="box">
        <div class="box-body">
<?php Pjax::begin(); ?>    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

//            'id',
            'username',
            'first_name',
            'last_name',
//            'auth_key',
            // 'password_hash',
            // 'password_reset_token',
             'email:email',
             'mobile',
            // 'role',
            // 'created_on',
            // 'logged_on',
            // 'status',
            // 'office_id',
            [
                'attribute' => 'status',
                'format' => 'raw',
                'value' => function($data) {    
                        return $data->status == 2 ? Html::a('Inactive', 'user/statusupdate/' . $data->id, ['class' => 'btn btn-xs btn-warning']) : Html::a('Active', 'user/statusupdate/' . $data->id, ['class' => 'btn btn-xs btn-success']);
                },
                        'filter' => Html::activeDropDownList($searchModel, 'status', ["1"=> "Active", "2" => "Inactive"], ['class' => 'form-control', 'prompt' => 'Select All']),
                    ],

            ['class' => 'yii\grid\ActionColumn'],
        ],
    ]); ?>
<?php Pjax::end(); ?>
        </div>
        </div>
    </div>
