<?php
/* @var $this yii\web\View */
/* @var $name string */
/* @var $message string */
/* @var $exception Exception */

use yii\helpers\Html;

$this->title = $name;
?>
<div class="site-error">

    <!-- Breadcrumbs Start -->
    <div class="rs-breadcrumbs">
        <img src="<?= Yii::getAlias('@web/') ?>images/breadcrumbs-bg.jpg" alt="Breadcrumbs Image">
        <div class="container">
            <div class="breadcrumbs-content">
                <h1 class="title"><?= Html::encode($this->title) ?></h1>
                <div class="page-path text-center">
                    <ul>
                        <li><a href="<?= Yii::getAlias('@web/') ?>">Home</a></li>
                        <li>Error</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <!-- Breadcrumbs End -->


    <!-- Contact Section Start -->
    <div class="contact-page-section sec-spacer">
        <div class="container">
            <div class="row onepage-style">
                <div class="col-lg-12 mb-md-30 pr-25">
                    <h1><?= Html::encode($this->title) ?></h1>
                    <div class="alert alert-danger">
                        <?= nl2br(Html::encode($message)) ?>
                    </div>
                    <p>
                        The above error occurred while the Web server was processing your request.
                    </p>
                    <p>
                        Please contact us if you think this is a server error. Thank you.
                    </p>
                </div>
            </div>
        </div>
    </div>
    <!-- Contact Section End -->
</div>
