<?php

namespace common\models;

use Yii;
use yii\helpers\ArrayHelper;
/**
 * This is the model class for table "user".
 *
 * @property int $id
 * @property string $customer_id
 * @property string $username
 * @property string $name
 * @property string $mobile
 * @property string $phone
 * @property string $email
 * @property string $address
 * @property string $district
 * @property int $role
 * @property int $added_by
 * @property string $auth_key
 * @property string $password_hash
 * @property string|null $password_reset_token
 * @property int $status
 * @property int $created_at
 * @property int $updated_at
 * @property string|null $verification_token
 */
class Staffs extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'user';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['username', 'name', 'mobile',  'address', 'role', 'status', 'auth_key', 'password_hash', 'created_at'], 'required'],
            [['address'], 'string'],
            [['role', 'added_by', 'status', 'created_at', 'updated_at'], 'integer'],
            [['customer_id', 'phone'], 'string', 'max' => 15],
            [['username', 'email', 'password_hash', 'password_reset_token', 'verification_token'], 'string', 'max' => 255],
            [['name'], 'string', 'max' => 35],
            [['mobile'], 'string', 'max' => 10],
            [['district'], 'string', 'max' => 25],
            [['auth_key'], 'string', 'max' => 32],
            [['username'], 'unique' ,  'message' => 'This username has already been entered.'],
            [['mobile'], 'unique',  'message' => 'This Mobile Number has already been entered.'],
            [['password_reset_token'], 'unique'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'customer_id' => 'Customer ID',
            'username' => 'Username',
            'name' => 'Name',
            'mobile' => 'Mobile',
            'phone' => 'Phone',
            'email' => 'Email',
            'address' => 'Address',
            'district' => 'District',
            'role' => 'Role',
            'added_by' => 'Added By',
            'auth_key' => 'Auth Key',
            'password_hash' => 'Password Hash',
            'password_reset_token' => 'Password Reset Token',
            'status' => 'Status',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
            'verification_token' => 'Verification Token',
        ];
    }

    public static function getAllStaffs() {
        $user_role = User::ROLE_USER;
        $staffsArray = User::find()->where(['status' => User::STATUS_ACTIVE])->andWhere(['!=', 'role', $user_role])->orderBy([
        'name' => SORT_ASC //specify sort order ASC for ascending DESC for descending      
    ])->asArray()->all(); //active organisation list

        $staff = array();
        foreach ($staffsArray as $key => $value) {
            $v['id'] = $value['id'];
            $v['name'] = $value['name'];
            array_push($staff, $v);
        }
        $staffs = ArrayHelper::map($staff, 'id', 'name');

        return $staffs;
    }
}
