<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "sms_log".
 *
 * @property integer $id
 * @property integer $office_id
 * @property integer $phone
 * @property string $message
 * @property string $sent_on
 * @property string $return_val
 * @property string $status
 */
class SmsLog extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'sms_log';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['phone', 'message', 'count', 'sent_on', 'status'], 'required'],
            [['id', 'phone', 'count'], 'integer'],
            [['message','return_val','status'], 'string'],
            [['sent_on'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'phone' => 'Sent To',
            'return_val' => 'Response',
            'message' => 'Message',
            'sent_on' => 'Sent On',
            'count' => 'Message count',
            'status' => 'Status',
        ];
    }
}
