<?php

namespace common\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\Services;

/**
 * ServicesSearch represents the model behind the search form of `common\models\Services`.
 */
class ServicesSearch extends Services
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'user_id', 'payment_status', 'attended_by', 'created_by'], 'integer'],
            [['service_number', 'service_note', 'service_type', 'service_mode', 'total_amount', 'amount_paid', 'call_type', 'completion_date', 'created_at', 'status'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Services::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'user_id' => $this->user_id,
            'payment_status' => $this->payment_status,
            'attended_by' => $this->attended_by,
            // 'completion_date' => $this->completion_date,
            'created_at' => $this->created_at,
            'created_by' => $this->created_by,
        ]);

        $query->andFilterWhere(['like', 'service_number', $this->service_number])
            ->andFilterWhere(['like', 'service_note', $this->service_note])
            ->andFilterWhere(['like', 'service_type', $this->service_type])
            ->andFilterWhere(['like', 'service_mode', $this->service_mode])
            ->andFilterWhere(['like', 'total_amount', $this->total_amount])
            ->andFilterWhere(['like', 'amount_paid', $this->amount_paid])
            ->andFilterWhere(['like', 'call_type', $this->call_type])
            ->andFilterWhere(['like', 'status', $this->status]);

        $startdateRange = explode(' ', $this->completion_date);
        if ($startdateRange[0] != '') {
            $query->andFilterWhere(['between', 'completion_date', $startdateRange[0], $startdateRange[2]]);
            $query->orFilterWhere(['like','completion_date',date('Y-m-d',  strtotime($startdateRange[0]))]);//for current date search
        }

        return $dataProvider;
    }
}
