<?php

namespace common\models;
use yii\helpers\ArrayHelper;
use Yii;

/**
 * This is the model class for table "services".
 *
 * @property int $id
 * @property string $service_number
 * @property int $user_id
 * @property string $service_note
 * @property string $service_type
 * @property string $service_mode
 * @property float $total_amount
 * @property float|null $amount_paid
 * @property int $payment_status
 * @property string $call_type
 * @property int $attended_by
 * @property string $completion_date
 * @property string $created_at
 * @property int $created_by
 * @property string $status
 */
class Services extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'services';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['service_number', 'user_id', 'service_note', 'service_type', 'service_mode', 'total_amount', 'payment_status', 'call_type', 'attended_by', 'completion_date', 'created_at', 'created_by', 'status'], 'required'],
            [['user_id', 'payment_status', 'attended_by', 'created_by'], 'integer'],
            [['service_note', 'service_mode', 'status'], 'string'],
            [['total_amount', 'amount_paid'], 'number'],
            [['completion_date', 'created_at'], 'safe'],
            [['service_number'], 'string', 'max' => 50],
            [['service_type'], 'string', 'max' => 20],
            [['call_type'], 'string', 'max' => 10],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'service_number' => 'Sl No',
            'user_id' => 'Customer',
            'service_note' => 'Service Note',
            'service_type' => 'Service Type',
            'serial_number' => 'Serial No',
            'service_mode' => 'Mode',
            'total_amount' => 'Total Amount',
            'amount_paid' => 'Amount Paid',
            'payment_status' => 'Payment Status',
            'call_type' => 'Call Type',
            'attended_by' => 'Attended By',
            'completion_date' => 'Completion Date',
            'created_at' => 'Created At',
            'created_by' => 'Created By',
            'status' => 'Status',
        ];
    }

    public function getCustomer() { 
        return $this->hasOne(Customers::className(), ['id' => 'user_id']); 
    }
    
    public static  function  getOfficeName($id){
    	$officeName = User::find()->where('id ='.$id);
    	$officeName = $officeName->asArray()->one();
    	return $officeName;
    }
    
    public static  function  getOffices(){
    	$offices = User::find()->where([ 'status'=>1, 'role'=>60 ])->orderBy(['company' => SORT_ASC])->all();
    	$offices = ArrayHelper::map($offices, 'id', 'company');
    	return $offices;

    }
}
