<?php

namespace common\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\Sales;

/**
 * SalesSearch represents the model behind the search form of `common\models\Sales`.
 */
class SalesSearch extends Sales
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'user_id'], 'integer'],
            [['invoice_number', 'invoice_date', 'due_date', 'notes', 'private_notes', 'status'], 'safe'],
            [['sub_total', 'discount_amount', 'cgst', 'sgst', 'igst', 'total_tax', 'invoice_amount', 'freight', 'round_off', 'amount_received', 'balance'], 'number'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Sales::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'user_id' => $this->user_id,
            'invoice_date' => $this->invoice_date,
            'due_date' => $this->due_date,
            'sub_total' => $this->sub_total,
            'discount_amount' => $this->discount_amount,
            'cgst' => $this->cgst,
            'sgst' => $this->sgst,
            'igst' => $this->igst,
            'total_tax' => $this->total_tax,
            'invoice_amount' => $this->invoice_amount,
            'freight' => $this->freight,
            'round_off' => $this->round_off,
            'amount_received' => $this->amount_received,
            'balance' => $this->balance,
        ]);

        $query->andFilterWhere(['like', 'invoice_number', $this->invoice_number])
            ->andFilterWhere(['like', 'notes', $this->notes])
            ->andFilterWhere(['like', 'private_notes', $this->private_notes])
            ->andFilterWhere(['like', 'status', $this->status]);

        return $dataProvider;
    }
}
