<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "sales_items".
 *
 * @property int $id
 * @property int $product_id
 * @property int $invoice_id
 * @property int $gst_percent
 * @property int $price
 * @property int $qty
 * @property float $sub_total
 * @property float $igst
 * @property float $sgst
 * @property float $cgst
 * @property float $total_tax
 * @property float $discount_amount
 * @property float $total_amout
 * @property float|null $setup_fee
 */
class SalesItems extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'sales_items';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['product_id', 'invoice_id', 'mrp', 'qty'], 'required'],
            [['product_id', 'invoice_id', 'gst_percent',  'qty'], 'integer'],
            [['sub_total', 'igst', 'sgst', 'cgst', 'total_tax', 'mrp', 'price','discount_amount', 'total_amout', 'setup_fee'], 'number'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'product_id' => 'Product',
            'invoice_id' => 'Invoice ID',
            'gst_percent' => 'Gst %',
            'price' => 'Price',
            'mrp'=>'Price',
            'qty' => 'Qty',
            'sub_total' => 'Sub Total',
            'igst' => 'IGST',
            'sgst' => 'SGST',
            'cgst' => 'CGST',
            'total_tax' => 'Total Tax',
            'discount_amount' => 'Discount',
            'total_amout' => 'Total Amout',
            'setup_fee' => 'Setup Fee',
        ];
    }
}
