<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "sales".
 *
 * @property int $id
 * @property int $user_id
 * @property string $invoice_number
 * @property string $invoice_date
 * @property string $due_date
 * @property string $notes
 * @property string $private_notes
 * @property float $sub_total
 * @property float $discount_amount
 * @property float $cgst
 * @property float $sgst
 * @property float $igst
 * @property float $total_tax
 * @property float $invoice_amount
 * @property string $status
 * @property float $freight
 * @property float $round_off
 * @property float $amount_received
 * @property float $balance
 */
class Sales extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'sales';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['user_id', 'invoice_number', 'invoice_date', 'due_date','status'], 'required'],
            [['user_id'], 'integer'],
            [['invoice_date', 'due_date', 'freight', 'round_off',], 'safe'],
            [['notes', 'private_notes', 'status'], 'string'],
            [['sub_total', 'discount_amount', 'cgst', 'sgst', 'igst', 'total_tax', 'invoice_amount', 'amount_received', 'balance'], 'number'],
            [['invoice_number'], 'string', 'max' => 20],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'user_id' => 'Customer',
            'invoice_number' =>'order Number',// 'Invoice Number',
            'invoice_date' => 'Order Date',// 'Invoice Date',
            'due_date' => 'Due Date',
            'notes' => 'Notes',
            'private_notes' => 'Private Notes',
            'sub_total' => 'Sub Total',
            'discount_amount' => 'Discount Amount',
            'cgst' => 'Cgst',
            'sgst' => 'Sgst',
            'igst' => 'Igst',
            'total_tax' => 'Total Tax',
            'invoice_amount' => 'Invoice Amount',
            'status' => 'Status',
            'freight' => 'Freight',
            'round_off' => 'Round Off',
            'amount_received' => 'Amount Received',
            'balance' => 'Balance',
        ];
    }
    public function getCustomer() { 
       return $this->hasOne(Customers::className(), ['id' => 'user_id']); 
   }
}
