<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "purchase_history".
 *
 * @property int $id
 * @property int $customer_id
 * @property int $product_id
 * @property string $purchased_on
 * @property int $added_by
 */
class PurchaseHistory extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'purchase_history';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['customer_id', 'product_id', 'purchased_on', 'added_by'], 'required'],
            [['customer_id', 'product_id', 'added_by'], 'integer'],
            [['purchased_on'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'customer_id' => 'Customer ID',
            'product_id' => 'Product ID',
            'purchased_on' => 'Purchased On',
            'added_by' => 'Added By',
        ];
    }
}
