<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "user".
 *
 * @property int $id
 * @property string $username
 * @property string $first_name
 * @property string $last_name
 * @property string $address
 * @property string $email
 * @property string $mobile
 * @property int $office_id
 * @property string $auth_key
 * @property string $password_hash
 * @property string $password_reset_token
 * @property int $role 10=>super admin, 20=>admin,30=>staff, 40=>user
 * @property int $status
 * @property int $created_at
 * @property int $updated_at
 * @property string $verification_token
 * @property string $utm_content
 *
 * @property WeddingData[] $weddingDatas
 */
class Profile extends \yii\db\ActiveRecord {

    public $password;
    public $password_repeat;

    /**
     * {@inheritdoc}
     */
    public static function tableName() {
        return 'user';
    }

    /**
     * {@inheritdoc}
     */
    public function rules() {
        return [
            [['password', 'password_repeat',], 'required'],
            ['password', 'string', 'min' => 6],
            ['password_repeat', 'string', 'min' => 6],
            ['password_repeat', 'compare', 'compareAttribute' => 'password', 'message' => "Passwords don't match"],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels() {
        return [
            'id' => 'ID',
            'username' => 'Username',
            'first_name' => 'First Name',
            'last_name' => 'Last Name',
            'address' => 'Address',
            'email' => 'Email',
            'mobile' => 'Mobile',
            'office_id' => 'Office ID',
            'auth_key' => 'Auth Key',
            'password_hash' => 'Password Hash',
            'password_reset_token' => 'Password Reset Token',
            'role' => 'Role',
            'status' => 'Status',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
            'verification_token' => 'Verification Token',
            'utm_content' => 'Utm Content',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getWeddingDatas() {
        return $this->hasMany(WeddingData::className(), ['user_id' => 'id']);
    }
 public function setPassword($password)
    {
        $this->password_hash = Yii::$app->security->generatePasswordHash($password);
    }
}
