<?php

namespace common\models;

use Yii;
use yii\helpers\Url;
use yii\helpers\ArrayHelper;
use common\components\Helper;
/**
 * This is the model class for table "products".
 *
 * @property int $id
 * @property int $category
 * @property string $product_name
 * @property string $product_code
 * @property string $hsn_code
 * @property string $description
 * @property int $tax_type
 * @property string $tax_percent
 * @property float $price
 * @property string $pic
 * @property int $status
 */
class Products extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'products';
    }

    public $_pic;
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['category', 'product_name', 'description', 'status'], 'required'],
            [['category', 'status'], 'integer'],
            [['description'], 'string'],
            [['price'], 'number'],
            [['_pic'], 'safe'],
            [['product_name'], 'string', 'max' => 100],
            [['product_code'], 'string', 'max' => 15], 
            [['hsn_code'], 'string', 'max' => 25], 
//            [['tax_percent'], 'string', 'max' => 5],
            [['pic'], 'string', 'max' => 200],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'category' => 'Category',
            'product_name' => 'Product Name',
            'product_code' => 'Product Code',
            'hsn_code' => 'HSN/SAC Code',
            'description' => 'Description',
            'unit' => 'Product Unit',
            //'tax_type' => 'Tax Type',
            //'tax_percent' => 'Tax Percent',
            'price' => 'Price for single item',
            'pic' => 'Pic',
            'status' => 'Status',
        ];
    }
    
    public function beforeSave($insert) {
//        stop($this->_pic);
        if (is_string($this->_pic) && strstr($this->_pic, 'data:image')) {
            $upload_path = Url::to('@common/../uploads/');
            // creating image file as png
            $data = $this->_pic;
            $data = base64_decode(preg_replace('#^data:image/\w+;base64,#i', '', $data));
            $fileName = time() . '-' . rand(100000, 999999) . '.png';
            file_put_contents($upload_path . 'products/' . $fileName, $data);
            // deleting old image 
            // $this->image is real attribute for filename in table
            // customize your code for your attribute            
            if (!$this->isNewRecord && !empty($this->pic)) {
                unlink(Yii::getAlias($upload_path . 'products/' . $this->pic));
            }
            // set new filename
            $this->pic = $fileName;
        }
        return parent::beforeSave($insert);
    }
    
    public static function getAllProducts() {
        $productsArray = Self::find()->where(['status' => User::STATUS_ACTIVE])->orderBy([
    'product_name' => SORT_ASC //specify sort order ASC for ascending DESC for descending      
    ])->asArray()->all(); //active organisation list
        $products = array();
        foreach ($productsArray as $key => $value) {
            $catagory = Helper::getProductCatagoryDetails($value['category']);
            $v['id'] = $value['id'];
            $v['name'] = $catagory->cat_name." ".$value['product_name'];
            array_push($products, $v);
        }
        $products = ArrayHelper::map($products, 'id', 'name');

        return $products;
    }
    
    
    
}
