<?php

namespace common\models;
use yii\helpers\ArrayHelper;

use Yii;

/**
 * This is the model class for table "product_units".
 *
 * @property int $id
 * @property string $uom
 * @property string $description
 */
class ProductUnits extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'product_units';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['uom', 'description'], 'required'],
            [['uom'], 'string', 'max' => 10],
            [['description'], 'string', 'max' => 50],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'uom' => 'Uom',
            'description' => 'Description',
        ];
    }
    
    public static function getAllUnits() {
        $unitsArray = self::find()->orderBy([
    'uom' => SORT_ASC //specify sort order ASC for ascending DESC for descending      
    ])->asArray()->all(); //active organisation list
        $unit = array();
        foreach ($unitsArray as $key => $value) {
            $v['id'] = $value['id'];
            $v['name'] = $value['uom']." - ".$value['description'];
            array_push($unit, $v);
        }
        $units = ArrayHelper::map($unit, 'id', 'name');

        return $units;
    }
}
