<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "product_category".
 *
 * @property int $id
 * @property string $cat_name
 * @property int $parrent_id
 */
class ProductCategory extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'product_category';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['cat_name', 'parrent_id'], 'required'],
            [['parrent_id'], 'integer'],
            [['cat_name'], 'string', 'max' => 100],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'cat_name' => 'Category Name',
            'parrent_id' => 'Parrent Category',
        ];
    }
    
    public static function getHierarchy() {
        $options = [];
         
        $parents = self::find()->where("parrent_id=0")->all();
        foreach($parents as $id => $p) {
            $children = self::find()->where("parrent_id=:parrent_id", [":parrent_id"=>$p->id])->all();
            $child_options = [];
            foreach($children as $child) {
                $child_options[$child->id] = $child->cat_name;
            }
            $options[$p->cat_name] = $child_options;
        }
        return $options;
    }
}
