<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "payments".
 *
 * @property int $id
 * @property int $service_id
 * @property string $note
 * @property int $amount
 * @property string $transaction_date
 * @property int $created_by
 * @property string $created_at
 */
class Payments extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'payments';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['service_id', 'note', 'amount', 'transaction_date', 'created_by', 'created_at'], 'required'],
            [['service_id', 'amount', 'created_by'], 'integer'],
            [['note'], 'string'],
            [['transaction_date', 'created_at'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'service_id' => 'Service ID',
            'note' => 'Note',
            'amount' => 'Amount',
            'transaction_date' => 'Transaction Date',
            'created_by' => 'Created By',
            'created_at' => 'Created At',
        ];
    }
}
