<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "orders".
 *
 * @property int $id
 * @property string $order_number
 * @property int $customer_id
 * @property string $order_date
 * @property string $created_at
 * @property int $created_by
 * @property string $status
 */
class Orders extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'orders';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['order_number', 'customer_id', 'order_date', 'created_at', 'created_by', 'status'], 'required'],
            [['customer_id', 'created_by'], 'integer'],
            [['order_date', 'created_at'], 'safe'],
            [['status'], 'string'],
            [['order_number'], 'string', 'max' => 50],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'order_number' => 'Order Number',
            'customer_id' => 'Customer',
            'order_date' => 'Order Date',
            'created_at' => 'Created At',
            'created_by' => 'Created By',
            'status' => 'Status',
        ];
    }
    public function getCustomer() { 
       return $this->hasOne(Customers::className(), ['id' => 'customer_id']); 
   }
}
