<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "order_items".
 *
 * @property int $id
 * @property int $order_id
 * @property int $product_cat
 * @property int $product_id
 * @property string $range
 * @property string $qty
 * @property int $price
 * @property string $next_billing_date
 * @property string $status 0-pending,1-active,2-suspended,3- cancelled,4-terminated
 */
class OrderItems extends \yii\db\ActiveRecord
{
    public $cat_id;
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'order_items';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['order_id', 'product_cat', 'product_id', 'range', 'qty', 'price',], 'required'],
            [['order_id', 'product_cat', 'product_id', 'price'], 'integer'],
            [['next_billing_date'], 'safe'],
            [['status'], 'string'],
            [['range'], 'string', 'max' => 25],
            [['qty'], 'string', 'max' => 5],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'order_id' => 'Order ID',
            'product_cat' => 'Product Category',
            'product_id' => 'Product',
            'range' => 'Range',
            'qty' => 'Qty',
            'price' => 'Per peice rate',
            'next_billing_date' => 'Next Billing Date',
            'status' => 'Status',
        ];
    }
}
