<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "leads".
 *
 * @property int $id
 * @property string $name
 * @property string $email
 * @property int $phone
 * @property int $lead_from 1=>website, 2=> staff/admin
 * @property int $added_by
 * @property int $district
 * @property string $status 0=>pending, 1=>completed, 2=>processing, 3=>cancelled 
 * @property string $created_at
 */
class Leads extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'leads';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['name',  'phone', 'lead_from', 'added_by', 'district', 'status', 'created_at'], 'required'],
            [['phone', 'lead_from', 'added_by', 'district'], 'integer'],
            [['status','note'], 'string'],
            [['email','created_at','follow_up'], 'safe'],
            [['name'], 'string', 'max' => 60],
            [['email'], 'string', 'max' => 200],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Name',
            'email' => 'Email',
            'phone' => 'Phone',
            'lead_from' => 'Lead From',
            'added_by' => 'Added By',
            'district' => 'District',
            'status' => 'Status',
            'created_at' => 'Created At',
        ];
    }
}
