<?php

namespace common\models;

use Yii;
use common\models\User;
use yii\helpers\ArrayHelper;
/**
 * This is the model class for table "user".
 *
 * @property int $id
 * @property string $username
 * @property string $name
 * @property string $mobile
 * @property string $phone
 * @property string $email
 * @property string $address
 * @property string $district
 * @property string $place
 * @property int $role
 * @property string $auth_key
 * @property string $password_hash
 * @property string|null $password_reset_token
 * @property int $status
 * @property int $created_at
 * @property int $updated_at
 * @property string|null $verification_token
 */
class Customers extends \yii\db\ActiveRecord {

    /**
     * {@inheritdoc}
     */
    public static function tableName() {
        return 'user';
    }

    /**
     * {@inheritdoc}
     */
    public function rules() {
        return [
            [['customer_id', 'username', 'name','serial_number','company','role', 'auth_key', 'password_hash', 'created_at'], 'required'],
            [['address', 'company'], 'string'],
            [['serial_number'], 'string', 'max' => 9, 'min' => 9],
            [['role', 'added_by', 'status', 'district', 'created_at', 'updated_at'], 'integer'],
            [['username', 'email', 'password_hash', 'password_reset_token', 'verification_token'], 'string', 'max' => 255],
            [['name'], 'string', 'max' => 35],
            [['mobile'], 'string', 'max' => 10],
            [['customer_id', 'phone'], 'string', 'max' => 15],
            [['auth_key'], 'string', 'max' => 32],
            [['serial_number'], 'unique', 'message' => 'This Serial Number has already been entered.'],
            [['password_reset_token'], 'unique'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels() {
        return [
            'id' => 'ID',
            'customer_id' => 'Customer ID',
            'username' => 'Username',
            'name' => 'Stp Name',
            'company' => 'Company/Firm Name',
            'mobile' => 'Mobile Number',
            'phone' => 'Phone Number',
            'email' => 'Email',
            'address' => 'Address',
            'district' => 'District',
            'role' => 'Role',
            'auth_key' => 'Auth Key',
            'password_hash' => 'Password Hash',
            'password_reset_token' => 'Password Reset Token',
            'status' => 'Status',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
            'verification_token' => 'Verification Token',
        ];
    }

    public static function getAllCustomers() {
        $customersArray = User::find()->where(['role' => User::ROLE_USER, 'status' => User::STATUS_ACTIVE])->orderBy([
    'name' => SORT_ASC //specify sort order ASC for ascending DESC for descending      
    ])->asArray()->all(); //active organisation list
        $customer = array();
        foreach ($customersArray as $key => $value) {
            $v['id'] = $value['id'];
            if($value['amc_status']==1)
            {
                $v['name'] = $value['company'] . ' ( Customer Id: ' . $value['customer_id'] . ", Mobile: " . $value['mobile'] . ' ) AMC Included';   
            }
            else{
                $v['name'] = $value['company'] . ' ( Customer Id: ' . $value['customer_id'] . ", Mobile: " . $value['mobile'] . ' )';
            }
            
            array_push($customer, $v);
        }
        $customers = ArrayHelper::map($customer, 'id', 'name');

        return $customers;
    }

    public static function getCustomersForAmc() {
        $customersArray = User::find()->where(['role' => User::ROLE_USER, 'amc_status' => User::STATUS_INACTIVE, 'status' => User::STATUS_ACTIVE])->orderBy([
    'name' => SORT_ASC //specify sort order ASC for ascending DESC for descending      
    ])->asArray()->all(); //active organisation list
        $customer = array();
        foreach ($customersArray as $key => $value) {
            $v['id'] = $value['id'];
            $v['name'] = $value['company'] . ' ( Customer Id: ' . $value['customer_id'] . ", Mobile: " . $value['mobile'] . ' )';
            array_push($customer, $v);
        }
        $customers = ArrayHelper::map($customer, 'id', 'name');

        return $customers;
    }


    public function getStateName() {
        return $this->hasOne(States::className(), ['id' => 'state']);
    }

    public function getCountryName() {
        return $this->hasOne(Countries::className(), ['id' => 'country']);
    }
}
