<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "company".
 *
 * @property int $id
 * @property string $logo
 * @property string $company_name
 * @property int $type
 * @property string $phone
 * @property string $email
 * @property string $address
 * @property int $country
 * @property int $state
 * @property int $state_code
 * @property int $pin
 * @property string $gstin
 * @property string $website
 * @property string $facebook
 * @property string $instagram
 * @property string $twitter
 */
class Company extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'company';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['logo', 'company_name', 'type', 'phone', 'email', 'address', 'country', 'state', 'state_code', 'pin', 'gstin', 'website', 'facebook', 'instagram', 'twitter'], 'required'],
            [['type', 'country', 'state', 'state_code', 'pin'], 'integer'],
            [['address'], 'string'],
            [['logo'], 'string', 'max' => 150],
            [['company_name'], 'string', 'max' => 100],
            [['phone', 'gstin'], 'string', 'max' => 15],
            [['email'], 'string', 'max' => 50],
            [['website'], 'string', 'max' => 30],
            [['facebook', 'instagram', 'twitter'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'logo' => 'Logo',
            'company_name' => 'Company Name',
            'type' => 'Type',
            'phone' => 'Phone',
            'email' => 'Email',
            'address' => 'Address',
            'country' => 'Country',
            'state' => 'State',
            'state_code' => 'State Code',
            'pin' => 'Pin',
            'gstin' => 'Gstin',
            'website' => 'Website',
            'facebook' => 'Facebook',
            'instagram' => 'Instagram',
            'twitter' => 'Twitter',
        ];
    }
    
    public function getStateName() {
        return $this->hasOne(States::className(), ['id' => 'state']);
    }

    public function getCountryName() {
        return $this->hasOne(Countries::className(), ['id' => 'country']);
    }
}
