<?php

namespace common\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\Amc;

/**
 * AmcSearch represents the model behind the search form of `common\models\Amc`.
 */
class AmcSearch extends Amc
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'user_id', 'created_by', 'status'], 'integer'],
            [['expiry'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Amc::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'user_id' => $this->user_id,
            // 'expiry' => $this->expiry,
            'created_by' => $this->created_by,
            'status' => $this->status,
        ]);

        $startdateRange = explode(' ', $this->expiry);
        if ($startdateRange[0] != '') {
            $query->andFilterWhere(['between', 'expiry', $startdateRange[0], $startdateRange[2]]);
            $query->orFilterWhere(['like','expiry',date('Y-m-d',  strtotime($startdateRange[0]))]);//for current date search
        }

        // if(isset ($this->expiry)&&$this->expiry!=''){ //you dont need the if function if yourse sure you have a not null date
        //     $date_explode=explode(" - ",$this->expiry);
        //     $date1=trim($date_explode[0]);
        //     $date2=trim($date_explode[1]);
        //     $query->andFilterWhere(['between','expiry',$date1,$date2]);
        //   }

        return $dataProvider;
    }
}
